package cn.com.duiba.goods.center.api.remoteservice.enums;

/**
 * 兑吧虚拟商品子类型枚举
 *
 * 只有当商品时虚拟商品时子类型才生效
 * @see cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemDto#subType
 * @author zhangruofan
 * @date 2019/02/02
 */
public enum VirtualSubType {
    /**
     * 支付宝转账
     */
    ALI_PAY(10, "通过支付宝用户id转账"),

    /**
     * 月补签卡
     */
    RESIGN_MONTH_CARD(11, "月补签卡"),
    /**
     * 衢州招行活动专用充值商品
     */
    QZZH_DUIBA_VIRTUAL(12, " 衢州招行活动专用商家自充"),

    /**
     * 多张集卡
     */
    COLLECT_CARDS(13, "多张集卡"),
    /**
     * 鼎信充值
     */
    JXABC_DUIBA_VIRTUAL(14, "鼎信充值"),
    /**
     * oppo微信红包定制
     * */
    OPPO_WECHAT_REDPACK_DUIBA_VIRTUAL(15, "oppo微信红包"),
    /**
     * 浙江中行话费
     */
    ZHEJIANG_ZHONGHANG_DUIBA_VIRTUAL(16,"浙江中行话费"),

    /**
     * 苏州招行-八维通优惠券
     */
    BWT_COUPON_DUIBA_VIRTUAL(17,"苏州招行八维通优惠券"),
    /**
     * 南京中信话费虚拟商品
     */
    NJZX_DUIBA_VIRTUAL(18,"南京中信话费虚拟商品"),

    /**
     * 工行卡中心立减金虚拟商品
     */
    ICBC_CARD_CENTER_DEDUCT_COUPON_DUIBA_VIRTUAL(19, "工行卡中心立减金虚拟商品"),

    /**
     * 南京中信乐享券
     */
    NJZX_LXQ_DUIBA_VIRTUAL(20,"南京中信乐享券"),

    /**
     * 苏州中信乐享券
     */
    SZZX_LXQ_DUIBA_VIRTUAL(21,"苏州中信乐享券"),

    /**
     * 陕西中烟虚拟商品
     */
    SXZY_DUIBA_VIRTUAL(22, "陕西中烟虚拟商品"),

    /**
     * 上海联通虚拟商品
     */
    SHANGHAI_UNICOM_DUIBA_VIRTUAL(23,"上海联通虚拟商品"),


    /**
     * 成都银行自充话费
     */
    CHENGDU_BANK_DUIBA_VIRYUAL(24,"成都银行自充话费"),

    ;

    private Integer code;
    private String desc;

    VirtualSubType(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getDesc() {
        return desc;
    }

    public Integer getCode() {
        return code;
    }
}
