/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.api.remoteservice.dto.item;

import cn.com.duiba.goods.center.api.remoteservice.util.GCRuntimeException;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;

public class PriceDegreeDto
implements Serializable {
    private static final long serialVersionUID = 3281272373039598785L;
    public static final String BIZPARAMS_REX = "\u03c8";
    public static final String PRICE_KEY = "price";
    public static final String CREDITS_KEY = "credits";
    public static final String TITLE_KEY = "title";
    public static final String LIMITCOUNT_KEY = "limitCount";
    public static final String LIMITSCOPE_KEY = "limitScope";
    private static Splitter spl = Splitter.on((String)"\u03c8").trimResults().omitEmptyStrings();
    private static Joiner join = Joiner.on((String)"\u03c8").skipNulls();
    private TreeMap<String, Map<String, String>> customDegree;
    private static Comparator<String> comparator = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            try {
                Long o1l = Long.valueOf(o1);
                Long o2l = Long.valueOf(o2);
                return o1l.compareTo(o2l);
            }
            catch (NumberFormatException e) {
                return o1.compareTo(o2);
            }
        }
    };

    public PriceDegreeDto() {
    }

    public PriceDegreeDto(String[] cps) {
        TreeMap map = Maps.newTreeMap(comparator);
        for (String cp : cps) {
            HashMap<String, String> hashmap = new HashMap<String, String>();
            if (cp.split(":").length > 2) {
                hashmap.put(CREDITS_KEY, cp.split(":")[1]);
                hashmap.put(TITLE_KEY, cp.split(":")[2]);
                map.put(cp.split(":")[0], hashmap);
                continue;
            }
            if (cp.split(":").length == 2) {
                hashmap.put(CREDITS_KEY, cp.split(":")[1]);
                map.put(cp.split(":")[0], hashmap);
                continue;
            }
            hashmap.put(CREDITS_KEY, null);
            map.put(cp.split(":")[0], hashmap);
        }
        this.customDegree = map;
    }

    public PriceDegreeDto(String customDegreeStr) {
        if (StringUtils.isBlank((String)customDegreeStr)) {
            this.customDegree = Maps.newTreeMap();
            return;
        }
        TreeMap map = Maps.newTreeMap(comparator);
        JSONArray ja = JSON.parseArray((String)customDegreeStr);
        for (int i = 0; i < ja.size(); ++i) {
            HashMap hashmap = Maps.newHashMap();
            if (ja.getJSONObject(i).getString(LIMITCOUNT_KEY) != null) {
                hashmap.put(CREDITS_KEY, this.getDegreeCredits(ja.getJSONObject(i).getString(CREDITS_KEY)));
                hashmap.put(LIMITCOUNT_KEY, ja.getJSONObject(i).getString(LIMITCOUNT_KEY));
                hashmap.put(LIMITSCOPE_KEY, ja.getJSONObject(i).getString(LIMITSCOPE_KEY));
                map.put(ja.getJSONObject(i).getString(PRICE_KEY), hashmap);
                continue;
            }
            if (ja.getJSONObject(i).getString(TITLE_KEY) != null) {
                hashmap.put(CREDITS_KEY, this.getDegreeCredits(ja.getJSONObject(i).getString(CREDITS_KEY)));
                hashmap.put(TITLE_KEY, ja.getJSONObject(i).getString(TITLE_KEY));
                map.put(ja.getJSONObject(i).getString(PRICE_KEY), hashmap);
                continue;
            }
            hashmap.put(CREDITS_KEY, this.getDegreeCredits(ja.getJSONObject(i).getString(CREDITS_KEY)));
            map.put(ja.getJSONObject(i).getString(PRICE_KEY), hashmap);
        }
        this.customDegree = map;
    }

    public static String getDegree(String bizParams) {
        if (StringUtils.isBlank((String)bizParams)) {
            return "";
        }
        List paramlist = spl.splitToList((CharSequence)bizParams);
        return (String)paramlist.get(0);
    }

    public static String getAccount(String bizParams) {
        if (StringUtils.isBlank((String)bizParams)) {
            return "";
        }
        List paramlist = spl.splitToList((CharSequence)bizParams);
        if (paramlist.size() >= 2) {
            return (String)paramlist.get(1);
        }
        return "";
    }

    public static String getBizParams(String degree, String account) {
        return join.join((Object)degree, (Object)account, new Object[0]);
    }

    private String getDegreeCredits(String creditsStr) {
        if (creditsStr == null || StringUtils.isBlank((String)creditsStr.trim())) {
            return null;
        }
        return creditsStr.trim();
    }

    public boolean isDegreeExist(String degree) {
        return this.customDegree.containsKey(degree);
    }

    public String serializePriceDegree() {
        JSONArray ja = new JSONArray();
        for (Map.Entry<String, Map<String, String>> entry : this.customDegree.entrySet()) {
            JSONObject jo = new JSONObject();
            jo.put(PRICE_KEY, (Object)entry.getKey());
            jo.put(CREDITS_KEY, (Object)entry.getValue().get(CREDITS_KEY));
            jo.put(TITLE_KEY, (Object)entry.getValue().get(TITLE_KEY));
            jo.put(LIMITCOUNT_KEY, (Object)entry.getValue().get(LIMITCOUNT_KEY));
            jo.put(LIMITSCOPE_KEY, (Object)entry.getValue().get(LIMITSCOPE_KEY));
            ja.add((Object)jo);
        }
        return ja.toString();
    }

    public void serializeUp200Alipay() {
        for (Map.Entry<String, Map<String, String>> entry : this.customDegree.entrySet()) {
            if (Integer.parseInt(entry.getKey()) <= 200) continue;
            throw new GCRuntimeException("\u652f\u4ed8\u5b9d\u9762\u503c\u4e0d\u80fd\u5927\u4e8e200");
        }
    }

    public void serializeUp500Alipay() {
        for (Map.Entry<String, Map<String, String>> entry : this.customDegree.entrySet()) {
            if (Integer.parseInt(entry.getKey()) <= 500) continue;
            throw new GCRuntimeException("\u652f\u4ed8\u5b9d\u9762\u503c\u4e0d\u80fd\u5927\u4e8e500");
        }
    }

    public String getCreditsByDegree(String degree) {
        return this.customDegree.get(degree).get(CREDITS_KEY);
    }

    public String getTitleByDegree(String degree) {
        return this.customDegree.get(degree).get(TITLE_KEY);
    }

    public Map<String, String> getLimitByDegree(String degree) {
        return this.customDegree.get(degree);
    }

    public String getMinDegreeKey() {
        return this.customDegree.firstKey();
    }

    public Integer getMinDegreeInt() {
        return Integer.valueOf(this.getMinDegreeKey());
    }

    public String getMinDegreeCredits() {
        String minDegreeCredits = this.customDegree.firstEntry().getValue().get(CREDITS_KEY);
        if (StringUtils.isBlank((String)minDegreeCredits)) {
            return null;
        }
        String temp = "";
        for (Map.Entry<String, Map<String, String>> entry : this.customDegree.entrySet()) {
            Map<String, String> ent = entry.getValue();
            if (StringUtils.isBlank((String)temp)) {
                temp = ent.get(CREDITS_KEY);
                continue;
            }
            if (!StringUtils.isNotBlank((String)ent.get(CREDITS_KEY)) || Long.valueOf(temp).compareTo(Long.valueOf(ent.get(CREDITS_KEY))) <= 0) continue;
            temp = ent.get(CREDITS_KEY);
        }
        if (StringUtils.isBlank((String)temp)) {
            return minDegreeCredits;
        }
        return temp;
    }

    public String getMinDegreeTitle() {
        return this.customDegree.firstEntry().getValue().get(TITLE_KEY);
    }

    public TreeMap<String, Map<String, String>> getCustomDegreeMap() {
        return this.customDegree;
    }

    public Long getMinCredits(Integer creditsRate) {
        Long a = 0L;
        for (Map.Entry<String, Map<String, String>> entry : this.customDegree.entrySet()) {
            if (a == 0L) {
                a = this.getCreditsValue((long)creditsRate, entry);
                continue;
            }
            a = this.getMinCreditsValue((long)creditsRate, a, entry);
        }
        return a;
    }

    public Long getMinCredits(Long creditsRate) {
        Long a = 0L;
        for (Map.Entry<String, Map<String, String>> entry : this.customDegree.entrySet()) {
            if (a == 0L) {
                a = this.getCreditsValue(creditsRate, entry);
                continue;
            }
            a = this.getMinCreditsValue(creditsRate, a, entry);
        }
        return a;
    }

    private Long getMinCreditsValue(Long creditsRate, Long minValue, Map.Entry<String, Map<String, String>> entry) {
        Long result = minValue;
        if (entry.getValue().get(CREDITS_KEY) != null) {
            if (minValue.compareTo(Long.valueOf(entry.getValue().get(CREDITS_KEY))) > 0) {
                result = Long.valueOf(entry.getValue().get(CREDITS_KEY));
            }
        } else if (minValue.compareTo(Long.valueOf(entry.getKey()) * creditsRate) > 0) {
            result = Long.valueOf(entry.getKey()) * creditsRate;
        }
        return result;
    }

    private Long getCreditsValue(Long creditsRate, Map.Entry<String, Map<String, String>> entry) {
        if (entry.getValue().get(CREDITS_KEY) != null) {
            return Long.valueOf(entry.getValue().get(CREDITS_KEY));
        }
        return Long.valueOf(entry.getKey()) * creditsRate;
    }

    public boolean isSingleDegree() {
        return this.customDegree.size() == 1;
    }

    static class CreditsComparator
    implements Comparator<Object>,
    Serializable {
        private static final long serialVersionUID = -2414083834670521985L;

        CreditsComparator() {
        }

        @Override
        public int compare(Object object1, Object object2) {
            String p1 = (String)object1;
            String p2 = (String)object2;
            return p2.compareTo(p1);
        }
    }
}

