package cn.com.duiba.goods.center.api.remoteservice.enums;

/**
 * 兑吧虚拟商品子类型枚举
 *
 * 只有当商品时虚拟商品时子类型才生效
 * @see cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemDto#subType
 * @author zhangruofan
 * @date 2019/02/02
 */
public enum VirtualSubType {
    /**
     * 支付宝转账
     */
    ALI_PAY(10, "通过支付宝用户id转账"),

    /**
     * 月补签卡
     */
    RESIGN_MONTH_CARD(11, "月补签卡"),
    ;

    private Integer code;
    private String desc;

    VirtualSubType(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getDesc() {
        return desc;
    }

    public Integer getCode() {
        return code;
    }
}
