package cn.com.duiba.goods.center.api.remoteservice.sku;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.goods.center.api.remoteservice.dto.sku.ItemSkuAtrributeDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.sku.ItemSkuDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.sku.RedefineSkuDto;

import java.util.List;
import java.util.Map;


@AdvancedFeignClient
public interface RemoteItemSkuService {
    /**
     * 根据兑吧商品id，查询sku信息
     */
    List<ItemSkuDto> findSkuListByItemId(Long itemId);

    /**
     * 根据兑吧商品id列表，查询sku信息
     */
    List<ItemSkuDto> findSkuByItemIdList(List<Long> itemIds);

    Integer batchSaveSku(List<ItemSkuDto> itemSkuDtoList);

    Integer deleteSkuByItemId(Long itemId);

    /**
     * 批量更新统一商品下的sku
     *
     * @param itemId
     * @param itemSkuDtoList
     * @return
     * @throws BizException
     */
    Integer batchUpdateSkuByItemId(Long itemId, List<ItemSkuDto> itemSkuDtoList) throws BizException;

    Map<Long, Long> batchUpdateCouponSkuByItemId(Long itemId, List<ItemSkuDto> itemSkuDtoList) throws BizException;

    /**
     * 查询sku
     * @param skuId
     * @return
     */
    ItemSkuDto findSkuById(Long skuId);

    /**
     * 查询sku列表
     * @param skuIdList
     * @return
     */
    List<ItemSkuDto> findSkuByIdList(List<Long> skuIdList);

    /**
     * 根据skuId集合返回sku的属性信息
     * 返回格式为 白色/XL
     * @param skuIdList
     * @return
     */
    List<RedefineSkuDto> findSkuRedefineValue(List<Long> skuIdList);

    /**
     * 根据item查询AppItemSkuAtrributeDto
     * @param itemIdList
     * @return
     */
    List<ItemSkuAtrributeDto> findSkuAttributeByItemIdList(List<Long> itemIdList);

    /**
     * 京东商品针对sku更新为可售状态
     * @param skuIdList
     * @return
     */
    Integer updateOnSaleState(List<Long> skuIdList);
    /**
     * 京东商品针对sku更新为不可售状态
     * @param skuId
     * @return
     */
    Integer updateOffSaleState(Long skuId);

    List<ItemSkuDto> findOffSaleSkuByItemIdList(List<Long> itemIds);

    List<ItemSkuDto> findSkuByMerchantCodingList(List<String> merchantCodingList);
    /**
     * 根据供货价上下限查询商品id
     * @author fengjun
     * @param limitHight 最高供货价，可不传
     * @param limitLow 最低供货价，可不传
     * @return 去重后的itemId
     * */
    List<Long> querySkuItemsBySuggestMarketPrice(Long limitLow,Long limitHight);

    /**
     * 批量查询同一个商品id下的SKU建议零售价最低的商品的SKU信息
     * @param itemIds 商品id列表，不可空
     * @return 最商品便宜的sku的集合，每个itemId对应一个sku
     * @author fengjun
     * 注意，此sql的结果，除了itemId和建议零售价的对应关系之外，其他值均不可信！！！！
     * **/
    List<ItemSkuDto> findCheapestSkuListByItemIds(List<Long> itemIds);
}
