package cn.com.duiba.goods.center.api.remoteservice.enums;

/**
 * 兑吧虚拟商品子类型枚举
 *
 * 只有当商品时虚拟商品时子类型才生效
 * @see cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemDto#subType
 * @author zhangruofan
 * @date 2019/02/02
 */
public enum VirtualSubType {
    /**
     * 支付宝转账
     */
    ALI_PAY(10, "通过支付宝用户id转账"),

    /**
     * 月补签卡
     */
    RESIGN_MONTH_CARD(11, "月补签卡"),
    /**
     * 衢州招行活动专用充值商品
     */
    QZZH_DUIBA_VIRTUAL(12, " 衢州招行活动专用商家自充"),

    /**
     * 多张集卡
     */
    COLLECT_CARDS(13, "多张集卡"),
    /**
     * 鼎信充值
     */
    JXABC_DUIBA_VIRTUAL(14, "鼎信充值"),
    /**
     * oppo微信红包定制
     * */
    OPPO_WECHAT_REDPACK_DUIBA_VIRTUAL(15, "oppo微信红包"),
    /**
     * 浙江中行话费
     */
    ZHEJIANG_ZHONGHANG_DUIBA_VIRTUAL(16,"浙江中行话费"),

    /**
     * 苏州招行-八维通优惠券
     */
    BWT_COUPON_DUIBA_VIRTUAL(17,"苏州招行八维通优惠券"),
    /**
     * 南京中信话费虚拟商品
     */
    NJZX_DUIBA_VIRTUAL(18,"南京中信话费虚拟商品"),

    /**
     * 工行卡中心立减金虚拟商品
     */
    ICBC_CARD_CENTER_DEDUCT_COUPON_DUIBA_VIRTUAL(19, "工行卡中心立减金虚拟商品"),

    /**
     * 南京中信乐享券
     */
    NJZX_LXQ_DUIBA_VIRTUAL(20,"南京中信乐享券"),

    /**
     * 苏州中信乐享券
     */
    SZZX_LXQ_DUIBA_VIRTUAL(21,"苏州中信乐享券"),

    /**
     * 陕西中烟虚拟商品
     */
    SXZY_DUIBA_VIRTUAL(22, "陕西中烟虚拟商品"),

    /**
     * 上海联通虚拟商品
     */
    SHANGHAI_UNICOM_DUIBA_VIRTUAL(23,"上海联通虚拟商品"),


    /**
     * 成都银行自充话费
     */
    CHENGDU_BANK_DUIBA_VIRYUAL(24,"成都银行自充话费"),

    /**
     * 工行卡中心电子券
     */
    ICBC_E_COUPON_DUIBA_VIRTUAL(26, "工行卡中心电子券"),

    /**
     * 泰康在线虚拟商品
     */
    TKONLINE_DUIBA_VIRYUAL(25, "泰康在线虚拟商品"),

    /**
     * 湖南联通虚拟商品
     */
    HNLT_DUIBA_VIRTUAL(27, "湖南联通虚拟商品"),

    /**
     * 古茗虚拟商品
     */
    GUMING_DUIBA_VIRTUAL(28, "古茗虚拟商品"),

    /**
     * 银联云闪付小程序专属红包
     */
    UNION_EXCLUSIVE_RED_PACKET_DUIBA_VIRTUAL(29, "银联云闪付小程序专属红包"),
    /**
     * 爱奇艺爱豆虚拟商品
     */
    IQIYI_DUIBA_VIRTUAL(30,"爱奇艺爱豆虚拟商品"),

    /**
     * 泰州农行虚拟商品
     */
    TAIZHOU_ABC_DUIBA_VIRTUAL(31, "泰州农行虚拟商品"),

    /**
     * 招行行外发奖虚拟商品
     */
    CMB_CHINA_OUTWARD_REWARD(32,"招行行外发奖虚拟商品"),

    /**
     * 携程虚拟商品
     */
    XIECHENG_DUIBA_VIRTUAL(33,"携程虚拟商品"),

    JD_COUPON_VIRTUAL(40, "京东-优惠券"),
    JD_POINTS_VIRTUAL(41, "京东-店铺积分"),
    JD_BEAN_VIRTUAL(42, "京东-京豆"),

    /**
     * 光大萌宠
     */
    GD_PET_VIRTUAL(43, "光大萌宠虚拟商品"),

    /**
     * 湖南联通虚拟商品--发积分
     */
    HNLT_JIFEN_DUIBA_VIRTUAL(44, "湖南联通虚拟商品--发积分")
    ;

    private Integer code;
    private String desc;

    VirtualSubType(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getDesc() {
        return desc;
    }

    public Integer getCode() {
        return code;
    }
}
