package cn.com.duiba.goods.center.api.remoteservice.sku;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.goods.center.api.remoteservice.dto.sku.AttributeLibraryDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.sku.AttributeValueDto;

import java.util.List;
import java.util.Map;


@AdvancedFeignClient
public interface RemoteAttributeValueService {
    /**
     * 根据属性Id，查询对应的属性值
     */
    List<AttributeValueDto> findAttributeValueByAttributeId(Long attributeValueById);

    List<AttributeValueDto> findAllAttributeValue();

    List<AttributeValueDto> findAttributeValueByAttributeIdList(List<AttributeLibraryDto> attributeLibraryDtoList);

    List<AttributeValueDto> findAttributeValueByIdList(List<Long> idList);

    /**
     * 保存规格属性
     *
     * @param attributeValueDto
     * @return
     * @throws BizException
     */
    Long saveAttributeValue(AttributeValueDto attributeValueDto) throws BizException;

    /**
     * 根据规格id列表查询
     *
     * @param attributeIds
     * @return
     */
    List<AttributeValueDto> findAttributeValueByAttributeIds(List<Long> attributeIds);

    /**
     * 根据规格和app查询
     *
     * @param attributeId
     * @param appId
     * @param attributeType
     * @return
     */
    List<AttributeValueDto> findByAttributeIdAndAppId(Long attributeId, Long appId, Integer attributeType);

    /**
     * 根据规格列表和app查询
     *
     * @param attributeIds
     * @param appId
     * @param attributeType
     * @return
     */
    List<AttributeValueDto> findByAttributeIdsAndAppId(List<Long> attributeIds, Long appId, Integer attributeType);

    /**
     * 批量保存
     *
     * @param list
     * @return
     * @throws BizException
     */
    List<Long> batchSave(List<AttributeValueDto> list) throws BizException;

    /**
     * 批量保存，key：规格id, value： 对象
     * @param list
     * @return
     * @throws BizException
     */
    Map<Long, List<AttributeValueDto>> batchSaveToMap(List<AttributeValueDto> list) throws BizException;

    /**
     * 根据规格查询京东信息
     *
     * @param attributeId
     * @param attributeType
     * @return
     */
    List<AttributeValueDto> findJdByAttributeIdAndType(Long attributeId, Integer attributeType);
}
