package cn.com.duiba.goods.center.api.remoteservice.equity;

import cn.com.duiba.api.bo.page.Page;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.goods.center.api.remoteservice.dto.equity.EquityGoodsRecordDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.equity.EquityVerificationCountDto;
import cn.com.duiba.goods.center.api.request.equity.FindPageRequest;
import cn.com.duiba.goods.center.api.request.equity.GoodsRecordFindPageConditions;

import java.util.List;

/**
 * @program: goods-center-all
 * @description: 权益商品
 * @author: Simba
 * @create: 2019-07-09 16:16
 **/
@AdvancedFeignClient
public interface RemoteEquityGoodsRecordService {

    Long save(EquityGoodsRecordDto dto);

    int batchInsert(List<EquityGoodsRecordDto> equityGoodsRecordDtoList);

    int deleteById(Long id);

    int deleteBatchByIds(List<Long> ids);

    List<EquityGoodsRecordDto> findByConditions(FindPageRequest request);

    int deleteBatchByBatchId(Long batchId);

    int deleteBatchByEquityId(Long equityId);

    int updateById(EquityGoodsRecordDto dto);

    List<EquityGoodsRecordDto> listByConditionParam(GoodsRecordFindPageConditions goodsRecordFindPageConditions);

    EquityGoodsRecordDto selectById(Long id);

    EquityGoodsRecordDto selectByCode(Long appId, String code);

    List<EquityGoodsRecordDto> selectByCodes(Long appId, List<String> codeList);

    List<EquityGoodsRecordDto> listByIds(List<Long> ids);

    List<String> selectExistCodeByCodes(Long appId, List<String> codeList);

    List<EquityVerificationCountDto> selectAllAndVerificationCountByEquityIds(List<Long> equityIds);

    Page<EquityGoodsRecordDto> findPageByConditions(FindPageRequest request);

    Long findPageCountByConditions(FindPageRequest request);

    Page<EquityGoodsRecordDto> findMerchantPageByConditions(FindPageRequest request);

    Long findMerchantPageCountByConditions(FindPageRequest request);

    List<EquityGoodsRecordDto> listByAppIdAndCodes(Long appId, List<String> codes);

    /**
     * 根据ids更新核销时间（当前时间）
     * @param merchantId 核销的商户id
     * @param ids 核销的权益商品id集合
     * @return
     */
    public int updateVerificationByIds(Long merchantId ,List<Long> ids);
}

