package cn.com.duiba.goods.center.api.remoteservice.model;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.goods.center.api.remoteservice.dto.model.*;
import cn.com.duiba.goods.center.api.remoteservice.enums.GoodsItemSourceType;

import java.util.List;

/**
 * 商品模型接口，提供：属性、规格、sku等标准商品模型接入服务
 * Created by xiaoxuda on 2018/7/31.
 */
@AdvancedFeignClient
public interface RemoteGoodsModelService {
    /**
     * 根据叶子类目Id查询对应类目下的所有属性及属性值
     * @param categoryId
     * @return
     */
    List<CategoryAttrValDto> findAttrByCategory(Long categoryId);

    /**
     * 加入商品模型
     * @param type 渠道类型
     * @param itemId 商品ID
     * @return 标准商品ID
     */
    Long joinGoodsModel(Long categoryId, GoodsItemSourceType type, Long itemId);

    /**
     * 根据渠道与ID反查标准商品信息
     * @param type
     * @param itemId
     * @return
     */
    GoodsItemDto findByTypeAndId(GoodsItemSourceType type, Long itemId);

    /**
     * 根据渠道与ID反查标准商品信息
     * @param type
     * @param itemIds
     * @return
     */
    List<GoodsItemDto> batchFindByTypeAndIds(GoodsItemSourceType type, List<Long> itemIds);

    /**
     * 保存商品属性配置
     * @param param
     * @return
     */
    boolean saveItemAttrVal(ItemAttrValConfigDto param);

    /**
     * 根据标准商品ID查询商品属性配置
     * @param goodsItemId
     * @return
     */
    ItemAttrValConfigDto findItemAttrValConfigDto(Long goodsItemId);

    /**
     * 商品SKU查询
     * @param goodsItemId
     * @return
     */
    GoodsItemSkuConfigDto findGoodsItemSku(Long goodsItemId);

    /**
     * 批量查询
     * @param goodsItemIds
     * @return
     */
    List<GoodsItemSkuConfigDto> batchFindGoodsItemSku(List<Long> goodsItemIds);

    /**
     * 保存商品sku
     * @param param
     * @return
     */
    boolean saveGoodsItemSku(GoodsItemSkuConfigDto param);

    /**
     * 更新商品与sku销量统计
     * @param goodsItemId
     * @param skuId
     * @param modify
     * @return
     */
    boolean updateSaleCount(Long goodsItemId, Long skuId, Integer modify);

    /**
     * 根据类目、数据来源及属性值查询商品ID
     * @param categoryId
     * @param type
     * @param attrValIds
     * @return
     */
    List<Long> batchFindItemIdByCategoryAndTypeAndAttrVal(Long categoryId, GoodsItemSourceType type, List<Long> attrValIds);

    /**
     * 交集查询（只查询符合当前属性值条数的商品，也就是attrValIds.size）
     * 根据类目、数据来源及属性值查询商品ID
     * @param categoryId
     * @param goodsItemSourceType GoodsItemSourceType.code
     * @param attrValIds
     * @return
     */
    List<Long> batchIntersectionFindItemIdByCategoryAndTypeAndAttrVal(Long categoryId, Integer goodsItemSourceType, List<Long> attrValIds);



    /**
     * 根据类目、数据来源查询商品ID
     * @param categoryId
     * @param type
     * @return
     */
    List<Long> batchFindItemIdByCategoryAndType(Long categoryId, GoodsItemSourceType type);

    /**
     * 通过skuId查询sku信息，包含属性值配置
     * @param skuId
     * @return
     */
    SkuConfigDto findById(Long skuId);
    /**
     * 通过skuIds查询sku信息，包含属性值配置
     * @param skuIds
     * @return
     */
    List<SkuConfigDto> findByIds(List<Long> skuIds);


    /**
     * 批量查询商品属性值信息
     * @param goodsItemIds
     * @return
     */
    List<GoodsItemAttrValDto> findByGoodsItemIds(List<Long> goodsItemIds);

    /**
     * 根据属性名 获取对应的属性ID集合（获取集合是为了防止出现重复的属性名）
     * @param attrName
     * @return
     */
    List<Long> listGoodAttrIdsByAttrName(String attrName);

    /**
     * 根据属性类型 获取属性id集合
     * @param attrType  属性类型，1：销售属性，2：:非销售属性
     * @return
     */
    List<Long> listGoodAttrIdsByAttrType(Integer attrType);



}
