package cn.com.duiba.goods.center.api.remoteservice.enums;

import java.util.Objects;

/**
 * Created by sunyan on 2020/7/9.
 * 虚拟商品充值账号格式
 */
public enum VirtualAccountFormatEnum {
    NONE(0,"不限格式"),
    MOBILE(1,"手机号");

    private Integer code;
    private String desc;

    VirtualAccountFormatEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }
    public static VirtualAccountFormatEnum getByCode(int code){
        for (VirtualAccountFormatEnum virtualAccountFormatEnum : values()) {
            if (Objects.equals(virtualAccountFormatEnum.getCode(), code)) {
                return virtualAccountFormatEnum;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
