package cn.com.duiba.goods.center.api.remoteservice.item;

import cn.com.duiba.api.enums.DuibaItemTypeEnum;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.goods.center.api.remoteservice.dto.SeckillAppItemDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.SeckillAppItemPageQueries;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.AppItemDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.AppItemNewQueries;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.AppItemPageQueries;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemKeyDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemQueries;
import cn.com.duiba.goods.center.api.remoteservice.dto.sku.ItemSkuDto;
import cn.com.duiba.goods.center.api.remoteservice.tool.Page;
import cn.com.duiba.wolf.dubbo.DubboResult;
import org.springframework.web.bind.annotation.RequestMapping;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 开发者商品后台接口
 */
@AdvancedFeignClient
public interface RemoteAppItemGoodsBackendService {

	/**
	 * 修改状态
	 *
	 * @return
	 */
	DubboResult<Integer> updateStatusByActivityId(String status, Boolean deleted, List<Long> relationIds);

	/**
	 * 根据兑吧商品ID查询开发者商品个数
	 *
	 * @param itemId
	 * @return
	 */
	DubboResult<Integer> findCountByItemId(Long itemId);

	/**
	 * 根据兑吧商品ID查询开发者上架和的商品
	 *
	 * @param itemId
	 * @return
	 */
	DubboResult<List<AppItemDto>> findOnShelfByItemId(Long itemId);

	/**
	 * 上架或者下架
	 */
	DubboResult<Integer> standUpOrDownAppItem(Long id, String status, Boolean deleted, Integer payload, Boolean homeDisplay);

	/**
	 * 更新活动工具兑换项入口
	 *
	 * @param id
	 * @param title
	 * @param smallImage
	 * @param whiteImage
	 * @param credits
	 * @param customPrice
	 * @param logo
	 * @param operationsType
	 * @return
	 * @Deprecated, 推荐用：updateHdtoolAppItem(AppItemDto dto)
	 */
	DubboResult<Integer> updateHdtoolAppItem(Long id, String title, String smallImage, String whiteImage, Long credits, String customPrice, String logo, Integer operationsType);


	/**
	 * 更新活动工具兑换项入口
	 *
	 * @param dto
	 * @return
	 */
	@RequestMapping("updateHdtoolAppItemByDto")
	DubboResult<Integer> updateHdtoolAppItem(AppItemDto dto);

	/**
	 * 更新专题活动主推兑换项属性
	 *
	 * @param id
	 * @param title
	 * @param logo
	 * @param smallImage
	 * @param whiteImage
	 * @param bannerImage
	 * @param credits
	 * @param subtitle
	 * @return
	 */
	DubboResult<Integer> updateMainPushAppItem(Long id, String title, String logo, String smallImage, String whiteImage, String bannerImage, Long credits, String subtitle);


	/**
	 * 更新专题活动主推兑换项属性
	 *
	 * @return
	 * @Deprecated, 推荐用：updateMainPushAppItem(AppItemDto dto)
	 */
	@Deprecated
	@RequestMapping("updateMainPushAppItemByDto")
	DubboResult<Integer> updateMainPushAppItem(AppItemDto dto);

	/**
	 * findAllBySourceTypeAndRelationIdAndDeleted
	 *
	 * @param sourceType
	 * @param sourceRelationId
	 * @param deleted
	 * @return
	 */
	DubboResult<List<AppItemDto>> findAllBySourceTypeAndRelationIdAndDeleted(int sourceType, long sourceRelationId, Boolean deleted);

	/**
	 * publishItem分页查询
	 *
	 * @param queryPublish
	 * @return
	 */
	DubboResult<Page<AppItemDto>> findPublishItemLimit(Map<String, Object> queryPublish);

	/**
	 * 分页查询
	 *
	 * @param params
	 * @return
	 */
	DubboResult<Page<AppItemDto>> findByLimit(Map<String, Object> params);

	/**
	 * 根据类型批量查询
	 *
	 * @param appId
	 * @param type
	 * @return
	 */
	DubboResult<List<AppItemDto>> findAllByAppIdAndInType(Long appId, String[] type);

	/**
	 * 根据类型查询
	 *
	 * @param appId
	 * @param type
	 * @return
	 */
	DubboResult<List<AppItemDto>> findAllByAppIdAndType(Long appId, String type);

	/**
	 * 获取上架中的兑换项数量，不包含活动兑换项入口
	 */
	DubboResult<Integer> findOnlineCount(Long appId);

	/**
	 * 获取库存不足的兑换项的数量，查询整个app下所有未删除商品的实时库存
	 * 注：此方法不推荐使用，查询整个app个所有商品库存请用odps service
	 */
	@Deprecated
	DubboResult<Integer> getRemaining0Count(Long appId);

	/**
	 * 获取直冲类的ID,没有则添加
	 */
	DubboResult<Long> getOrAddAppItemId(String type, Long appId, Long appCreditsRate);

	/**
	 * findAllUpVirtaulAppItems
	 *
	 * @param appId
	 * @return
	 */
	DubboResult<List<AppItemDto>> findAllUpVirtaulAppItems(Long appId);

	/**
	 * doBatchDel
	 * 删除完毕后需要调用 DuibaEventsDispatcher.get().dispatchEvent(new ItemEvent(ItemEvent.ItemEventType.onDeleted, key));
	 *
	 * @param appId
	 * @param developerId
	 * @param appItemIds
	 */
	DubboResult<Boolean> doBatchDel(Long appId, Long developerId, List<Long> appItemIds);

	/**
	 * 添加一次测试商品
	 *
	 * @param appId
	 */
	DubboResult<Long> addTestAppItem(Long appId);

	/**
	 * 批量上架
	 *
	 * @param appId
	 * @param appItemIds
	 * @return
	 */
	DubboResult<Integer> bathcStandUp(Long appId, String virtualExchangeUrl, List<Long> appItemIds);

	/**
	 * 上架或者下架
	 */
	DubboResult<Boolean> standUpOrDown(Long appId, Long appItemId, String status);

	Boolean paceVirtualSku(List<ItemSkuDto> itemSkuDtoList,Long itemId) throws BizException;

	/**
	 * 排序自定义分类
	 *
	 * @param classifyId
	 * @param appItemIds
	 * @return
	 */
	DubboResult<Integer> sortClassifyAppItem(Long classifyId, List<Long> appItemIds);

	/**
	 * 修改实物商品
	 *
	 * @param appItem
	 * @param preRemaining
	 * @param remaining
	 * @param exchangeLimit
	 * @param arealimitSwitch
	 * @param arealimitType
	 * @param arealimitAreas
	 * @return
	 */
	DubboResult<Long> doUpdateOwnerObject(AppItemDto appItem, Integer preRemaining, Integer remaining, String exchangeLimit, String arealimitSwitch, String arealimitType, String arealimitAreas);

	/**
	 * 新增商品（老逻辑，强制版本号为0）
	 *
	 * @param appItemDto
	 * @return
	 */
	Long insert(AppItemDto appItemDto);

	/**
	 * 新增商品（新逻辑，强制版本为1）
	 *
	 * @param appItemDto
	 * @return
	 */
	Long insertNew(AppItemDto appItemDto);

	/**
	 * 全量更新
	 *
	 * @param appItem
	 * @return
	 */
	void updateAll(AppItemDto appItem);

	/**
	 * 获取app下所有上架的可用的自有商品
	 *
	 * @param appId
	 * @param types    类型
	 * @param warnLine 库存预警线(实物,虚拟商品)
	 * @return
	 */
	DubboResult<List<Long>> findSelfAppItemIdsByAppId(Long appId, List<String> types, Integer warnLine);

	/**
	 * selectItemStore
	 *
	 * @param appId
	 * @param itemId
	 * @return
	 */
	DubboResult<AppItemDto> selectItemStore(Long appId, Long itemId);

	/**
	 * addItem2Myrepo
	 *
	 * @param appId
	 * @param itemId
	 * @return
	 */
	DubboResult<AppItemDto> addItem2Myrepo(Long appId, Long itemId, Long developerId, Long creditsRate);

	/**
	 * 修改虚拟商品
	 *
	 * @param appItem
	 * @param preRemaining
	 * @param remaining
	 * @param isOnSale
	 * @return
	 */
	DubboResult<AppItemDto> doUpdateVirtual(AppItemDto appItem, Integer preRemaining, Integer remaining, boolean isOnSale);

	/**
	 * 删除开发者商品
	 *
	 * @param appId
	 * @param appItemId
	 * @return
	 */
	DubboResult<Boolean> deleteAppItem(Long appId, Long appItemId);

	/**
	 * 根据运费模板ID查询
	 *
	 * @param expressTemplateId
	 * @return
	 */
	DubboResult<List<AppItemDto>> findAllByExpressTemplateId(Long expressTemplateId);

	DubboResult<List<AppItemDto>> findAllByAppIdAndTypeExceptSeries(Long appId, String type);

	List<AppItemDto> findAllByAppIdAndTypeExceptSeriesWithAmb(Long appId, String type) throws BizException;

	/**
	 * 查询APP所有的虚拟商品
	 *
	 * @param appId
	 * @return
	 */
	DubboResult<List<AppItemDto>> findAllVirtualValid(Long appId);

	/**
	 * 分页查询虚拟商品数据
	 * @param appId
	 * @return
	 */
	Page<AppItemDto> pageQueryVirtualValid(Long appId,int pageNo,int pageSize) throws BizException;


	DubboResult<List<AppItemDto>> findSelfModeAndAmbItem(Long appId);

	/**
	 * 根据兑吧商品ID查询
	 *
	 * @param appId
	 * @param itemId
	 * @return
	 */
	DubboResult<AppItemDto> findByAppIdAndItemId(Long appId, Long itemId);

	/**
	 * findAppItemLimit
	 *
	 * @param param
	 * @param start
	 * @param pageSize
	 * @return
	 */
	DubboResult<List<AppItemDto>> findAppItemLimit(Map<String, Object> param, int start, int pageSize);

	/**
	 * findAppItemCount
	 *
	 * @param param
	 * @return
	 */
	DubboResult<Long> findAppItemCount(Map<String, Object> param);

	/**
	 * APP商品首页排序
	 *
	 * @param appId
	 * @param appItemId
	 * @param startPayload
	 * @param endPayload
	 */
	DubboResult<Void> sortByAppItemIdAndRange(Long appId, Long appItemId, Integer startPayload, Integer endPayload);

	/**
	 * 修改limit为null
	 *
	 * @param appItemId
	 * @param limitCount
	 * @param limitTimeBetween
	 * @param limitEverydayQuantity
	 */
	DubboResult<Void> setLimitNull(Long appItemId, Integer limitCount, String limitTimeBetween, Integer limitEverydayQuantity);

	/**
	 * updateAutoOffDateNull
	 *
	 * @param id
	 * @return
	 */
	DubboResult<Integer> updateAutoOffDateNull(Long id);

	/**
	 * findAllByAppAndIsOwner
	 *
	 * @param appId
	 * @param isOwner
	 * @return
	 */
	DubboResult<List<AppItemDto>> findAllByAppAndIsOwner(Long appId, Boolean isOwner);

	/**
	 * selectHasUpItems
	 *
	 * @param ids
	 * @param appId
	 * @return
	 */
	DubboResult<List<Long>> selectHasUpItems(List<Long> ids, Long appId);

	/**
	 * 修改优惠券
	 *
	 * @param appItem
	 * @param exchangeLimit
	 * @param arealimitSwitch
	 * @param arealimitType
	 * @param arealimitAreas
	 * @param usePrompt
	 * @param btnText
	 */
	DubboResult<Long> doUpdateCoupon(AppItemDto appItem, String exchangeLimit, String arealimitSwitch, String arealimitType, String arealimitAreas, String usePrompt, String btnText);

	/**
	 * 根据itemIds in 和 appId
	 *
	 * @param itemIds
	 * @param appId
	 * @return
	 */
	DubboResult<List<AppItemDto>> findAllByItemIdsAndAppId(List<Long> itemIds, Long appId);

	/**
	 * findByAppAndItemOnline
	 *
	 * @param appId
	 * @param itemId
	 * @return
	 */
	DubboResult<AppItemDto> findByAppAndItemOnline(Long appId, Long itemId);

	DubboResult<List<AppItemDto>> findAllByIds(List<Long> ids);

	DubboResult<List<AppItemDto>> getByItemId(Long itemId);

	/**
	 * @param query
	 * @param start
	 * @param pageSize
	 * @return
	 */
	DubboResult<List<AppItemDto>> findAppItemNoExistClassify(Map<String, Object> query, Integer start, Integer pageSize);

	/**
	 * 根据自定义分类查找自有商品
	 *
	 * @param classifyId 分类id
	 * @param appId      app id
	 * @param status
	 * @return
	 */
	DubboResult<List<AppItemDto>> findClassifyAppItems(Long classifyId, Long appId, String status);

	/**
	 * 查询app所有兑换项
	 */
	List<AppItemDto> findAllAppItem(Map<String, Object> param);

	/**
	 * 根据appId查询
	 */
	List<AppItemDto> findAllByAppId(Long appId);


	DubboResult<Integer> findAppItemNoExistClassifyCount(Map<String, Object> query, Integer start, Integer pageSize);

	/**
	 * 根据classifyId, appId查找AppItem
	 *
	 * @param appId
	 * @param classifyId
	 * @return
	 */
	DubboResult<List<AppItemDto>> findHomeClassifyAppItems(Long appId, Long classifyId);

	void updateSubTypeById(Long appItemId, Integer subType);

	void updateValidEndDate(Long appItemId, Date date);

	void updateExpiedAppItemById(Long appItemId);

	DubboResult<List<Long>> findIdByVirtaulType(Long appId);

	/**
	 * 删除运营活动兑换项
	 */
	DubboResult<Integer> updateStatusByOperationActivityId(String status, Boolean delete, Long relationId);

	DubboResult<List<AppItemDto>> findAutoOffAppItem();

	/**
	 * 更新运营活动状态
	 */
	DubboResult<Integer> updateOperationsTypeById(Long id, Integer operationsType);

	DubboResult<Integer> updateStatusAndSubStatusByItemId(Long itemId, String status, String subStatus);

	/**
	 * 查询自有过期产品（7天 < valid_end_date < new Date）
	 */
	DubboResult<List<AppItemDto>> findSelfOverdueAppItem(String type);

	DubboResult<Integer> updateStatusAndSubStatusById(Long id, String status, String subStatus);

	/**
	 * 计划任务用查询是否在库中
	 */
	DubboResult<AppItemDto> selectItemStore4Task(Long appId, Long itemId);

	/**
	 * 开发者秒杀商品列表
	 *
	 * @param appId
	 * @return
	 */
	DubboResult<List<AppItemDto>> findSecKillAppItem(Long appId);

	/**
	 * 根据ID集合查询应用商品信息
	 *
	 * @param ids
	 * @param deleted 删除状态，为null表示不管状态
	 * @return
	 */
	List<AppItemDto> findByIds(List<Long> ids, Boolean deleted);

	/**
	 * 根据ID集合 上下架状态 查询应用商品信息
	 *
	 * @param ids
	 * @param deleted 删除状态，为null表示不管状态
	 * @return
	 */
	List<AppItemDto> findByIdsWhithStatus(List<Long> ids, Boolean deleted, String status);

	/**
	 * 新的修改虚拟商品的接口,支持低于屏蔽
	 *
	 * @param appItem
	 * @param preRemaining
	 * @param remaining
	 * @param isOnSale
	 * @param exchangeLimit
	 * @param arealimitSwitch
	 * @param arealimitType
	 * @param arealimitAreas
	 * @return
	 */
	AppItemDto doUpdateVirtual2(AppItemDto appItem, Integer preRemaining, Integer remaining, boolean isOnSale, String exchangeLimit, String arealimitSwitch, String arealimitType, String arealimitAreas);

	/**
	 * 后台商品显示不用缓存
	 *
	 * @param id
	 * @return
	 */
	AppItemDto findWithoutCache(Long id) throws BizException;

	/**
	 * 按需查找商品信息
	 *
	 * @param id
	 * @param queries 查询参数，null查询全部
	 * @return
	 */
	AppItemDto findWithQueries(Long id, ItemQueries queries) throws BizException;

	Boolean batchUpdateMainPushAppItem(List<AppItemDto> dtoList) throws BizException;

	/**
	 * @param appId
	 * @param appItemId
	 * @return
	 * @throws BizException
	 */
	Boolean standDownWithNotification(Long appId, Long appItemId) throws BizException;

	/**
	 * 更新属性列表修改
	 *
	 * @param itemId
	 * @param changedStatus @Reference ChangedStatusEnum
	 * @return
	 */
	Integer updateAttrChangedByItemId(Long itemId, int changedStatus);

	/**
	 * 将老版本商品转换成新版本商品
	 *
	 * @param appItemId
	 * @throws BizException
	 */
//	void convertOldVersion(Long appItemId) throws BizException;

	/**
	 * 重新构建sku
	 *
	 * @param appItemId
	 * @throws BizException
	 */
	void rebuildChangedSku(Long appItemId) throws BizException;

	/**
	 * 开发者后台分页查询
	 *
	 * @param queries
	 * @return
	 */
	@Deprecated
	Page<AppItemDto> page(AppItemPageQueries queries, boolean withTotal) throws BizException;

	/**
	 * 开发者后台分页查询，新接口
	 *
	 * @param queries
	 * @param withTotal
	 * @return
	 * @throws BizException
	 */
	Page<ItemKeyDto> pageNew(AppItemPageQueries queries, boolean withTotal) throws BizException;

	/**
	 * 批量下架
	 *
	 * @param appId
	 * @param appItemIds
	 * @param status
	 * @return
	 */
	void batchStandUpOrDown(Long appId, List<Long> appItemIds, String status);

	/**
	 * 批量复制
	 *
     * @param sourceAppId 源appid
     * @param appItemIds 源商品id列表
     * @param destAppIds 目标appid列表
	 * @throws BizException
     * @return
	 */
    int batchCopy(Long sourceAppId, List<Long> appItemIds, List<Long> destAppIds) throws BizException;

	/**
	 * 更新老版本
	 *
	 * @param appItem
	 * @return
	 */
	void updateNew(AppItemDto appItem);

	/**
	 * 新秒杀查询商品列表
	 *
	 * @param queries
	 * @return
	 */
	Page<SeckillAppItemDto> select4NewSeckill(SeckillAppItemPageQueries queries);

	/**
	 * 更新售价为空, 不推荐使用，若使用请联系商品交易组
	 *
	 * @param id
	 * @return
	 */
	@Deprecated
	int updateSalePriceNull(Long id) throws BizException;

	/**
	 * @Desc 根据商品全部名称查询
	 * @params [appId, fullTitle, types]
	 */
	List<AppItemDto> findAllByFullName(Long appId, String fullTitle) throws BizException;

	/**
	 * 批量更新商品标记位
	 *
	 * @param map
	 * @return
	 */
    int batchUpdateOperationsType(Map<Long, Integer> map);

    /**
     * 更新自动下架时间
     *
     * @param id
     * @param autoOffDate
     * @return
     */
    int updateAutoOffDate(Long id, Date autoOffDate);

    /**
     * 批量清除自动下架时间
     *
     * @param ids
     * @return
     */
    int batchUpdateAutoOffDateNull(List<Long> ids);

    /**
     * 更新排序值
     *
     * @param id
     */
    void updatePayload(Long id, int payload);

    /**
     * 批量增加app下指定排序值之后的排序值
     *
     * @param appId
     * @param minPayload 最小排序值，会对 大于等于 该值的记录 排序值+1
     */
    void batchIncreasePayload(Long appId, int minPayload);

    /**
     * 批量减少app下指定排序值之前的排序值
     *
     * @param appId
     * @param maxPayload 最大排序值，会对 小于等于 该值的记录 排序值-1
     */
	void batchDecreaseTopPayload(Long appId, int maxPayload);

	/**
	 * 批量增加app置顶商品下指定排序值之后的排序值
	 *
	 * @param appId
	 * @param minPayload 最小排序值，会对 大于等于 该值的记录 排序值+1
	 */
	void batchIncreaseTopPayload(Long appId, int minPayload);

	/**
	 * 批量减少app置顶商品下指定排序值之前的排序值
	 *
	 * @param appId
	 * @param maxPayload 最大排序值，会对 小于等于 该值的记录 排序值-1
	 */
	void batchDecreasePayload(Long appId, int maxPayload);

	/**
	 * 新商品查询不分页
	 *
	 * @param queries
	 * @return
	 */
	List<AppItemDto> selectNewItem(AppItemNewQueries queries);

	List<AppItemDto> findSimpleByIds(List<Long> appItemIds);

	/**
	 * 获取添加到开发者商品库的兑吧卡券直充商品（item_id is not null and operations_type & (1 << 24) = (1 << 24)）
	 * @param appId 开发者appId @notnull
	 * @return 列表
	 */
	List<AppItemDto> findAllDuibaVProByAppId(Long appId);
}