/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.api.remoteservice.tool.sku;

import cn.com.duiba.goods.center.api.remoteservice.dto.sku.AppItemSkuDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.sku.SkuAttributeNode;
import cn.com.duiba.goods.center.api.remoteservice.tool.UnitUtils;
import cn.com.duiba.goods.center.api.remoteservice.tool.sku.AbstractSkuResolver;
import org.apache.commons.lang.StringUtils;

public class AppItemSkuResolver
extends AbstractSkuResolver<AppItemSkuDto, SkuAttributeNode.AppItemSkuInfo> {
    @Override
    protected AppItemSkuDto toDto(Long appItemId, Long itemId, String attributeJson, SkuAttributeNode.AppItemSkuInfo skuInfo) {
        AppItemSkuDto appItemSku = new AppItemSkuDto();
        appItemSku.setAppItemId(appItemId);
        appItemSku.setItemId(itemId);
        appItemSku.setAttributeJson(attributeJson);
        appItemSku.setId(this.parseString2Long(skuInfo.getId()));
        appItemSku.setFacePrice(UnitUtils.transformYuan2Fen(skuInfo.getFacePrice()));
        appItemSku.setSalePrice(UnitUtils.transformYuan2Fen(skuInfo.getSalePrice()));
        appItemSku.setSupplyPrice(UnitUtils.transformYuan2Fen(skuInfo.getSupplyPrice()));
        appItemSku.setMerchantCoding(skuInfo.getMerchantCoding());
        appItemSku.setRemaining(skuInfo.getRemaining());
        appItemSku.setPreRemaining(skuInfo.getPreRemaining());
        appItemSku.setImgUrl(skuInfo.getImgUrl());
        appItemSku.setStockId(this.parseString2Long(skuInfo.getStockId()));
        appItemSku.setItemSkuId(this.parseString2Long(skuInfo.getItemSkuId()));
        appItemSku.setCardLibraryId(this.parseString2Long(skuInfo.getCardLibraryId()));
        appItemSku.setSaleStatus(skuInfo.getSaleStatus());
        return appItemSku;
    }

    @Override
    protected String getAttributeJson(AppItemSkuDto sku) {
        return sku.getAttributeJson();
    }

    @Override
    protected SkuAttributeNode.AppItemSkuInfo toVo(AppItemSkuDto sku) {
        SkuAttributeNode.AppItemSkuInfo skuInfo = new SkuAttributeNode.AppItemSkuInfo();
        skuInfo.setId(this.parseLong2String(sku.getId()));
        skuInfo.setFacePrice(UnitUtils.transformFen2Yuan(sku.getFacePrice()));
        skuInfo.setSalePrice(UnitUtils.transformFen2Yuan(sku.getSalePrice()));
        skuInfo.setSupplyPrice(UnitUtils.transformFen2Yuan(sku.getSupplyPrice()));
        skuInfo.setMerchantCoding(sku.getMerchantCoding());
        skuInfo.setImgUrl(sku.getImgUrl());
        skuInfo.setStockId(this.parseLong2String(sku.getStockId()));
        skuInfo.setItemSkuId(this.parseLong2String(sku.getItemSkuId()));
        skuInfo.setRemaining(sku.getRemaining());
        skuInfo.setPreRemaining(sku.getPreRemaining());
        skuInfo.setCardLibraryId(this.parseLong2String(sku.getCardLibraryId()));
        skuInfo.setSaleStatus(sku.getSaleStatus());
        return skuInfo;
    }

    @Override
    protected SkuAttributeNode.AppItemSkuInfo getSkuInfo(SkuAttributeNode<SkuAttributeNode.AppItemSkuInfo> node) {
        SkuAttributeNode.AppItemSkuInfo skuInfo = node.getSkuInfo();
        if (skuInfo != null && StringUtils.isBlank((String)skuInfo.getImgUrl())) {
            skuInfo.setImgUrl(node.getImgUrl());
        }
        return super.getSkuInfo(node);
    }

    @Override
    protected void postNode(SkuAttributeNode<SkuAttributeNode.AppItemSkuInfo> headNode, SkuAttributeNode<SkuAttributeNode.AppItemSkuInfo> node) {
        SkuAttributeNode.AppItemSkuInfo skuInfo = node.getSkuInfo();
        if (skuInfo != null && headNode.getImgUrl() == null) {
            headNode.setImgUrl(skuInfo.getImgUrl());
        }
        super.postNode(headNode, node);
    }
}

