package cn.com.duiba.goods.center.api.remoteservice.param;

import java.io.Serializable;
import java.util.List;

/**
 * 通用查询参数
 * Created by xiaoxuda on 2017/7/13.
 */
public class AppItemQueryParam extends PageParam implements Serializable{
    private static final long serialVersionUID = -3844500886516757306L;
    /**
     * 应用ID
     */
    private Long appId;
    /**
     * 上架状态，@see AppItemDto.Status*
     */
    private String status;
    /**
     * 是否已删除，默认为false
     */
    private Boolean deleted = false;
    /**
     * 商品类型，@see ItemDto.Type*
     */
    private List<String> types;
    /**
     * 是否在首页展示
     */
    private Boolean homeDisplay;

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Boolean getDeleted() {
        return deleted;
    }

    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    public List<String> getTypes() {
        return types;
    }

    public void setTypes(List<String> types) {
        this.types = types;
    }

    public Boolean getHomeDisplay() {
        return homeDisplay;
    }

    public void setHomeDisplay(Boolean homeDisplay) {
        this.homeDisplay = homeDisplay;
    }
}
