package cn.com.duiba.goods.center.api.remoteservice.enums;

public enum CouponOperationLogEnum {
    IMPORT_INSERT(1, "导入券码"),
    EXPORT_TURNOUT(2, "导出券码"),
    DELETED(3, "券码删除"),
    RECOVERY(4, "券码回收"),
    DELETED_BATCH(5, "删除批次"),
    ALLOT(6, "分配券码"),
    OUTER_TURNOUT(7, "外发券码"),
    ;
    /** 类型代码 */
    private Integer code;
    /** 描述 */
    private String desc;

    CouponOperationLogEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public static CouponOperationLogEnum getCouponOperationLogEnum(int code) {
        CouponOperationLogEnum[] values = CouponOperationLogEnum.values();
        for (CouponOperationLogEnum value : values) {
            if (value.getCode() == code) {
                return value;
            }
        }

        return null;
    }
}
