package cn.com.duiba.goods.center.api.remoteservice.enums;

/**
 * @Description
 * @Date 2023/5/15 12:30
 * @Author LuHui
 */
public enum SupplierProductEnum {
    SUPPLIER_PHONE_BILL_PUUP_INCLUDE_TAX("phonebill-puup-tax", "浦上"),
    SUPPLIER_PHONE_BILL_PUUP_TAX_FREE("phonebill-puup", "浦上"),
    SUPPLIER_PHONE_BILL_XIANGSHANG_INCLUDE_TAX("phonebill-xiangshang-tax", "向上"),
    SUPPLIER_PHONE_BILL_XIANGSHANG_TAX_FREE("phonebill-xiangshang", "向上"),
    SUPPLIER_PHONE_BILL_KACHI_INCLUDE_TAX("phonebill-kachi-tax", "卡池"),
    SUPPLIER_PHONE_BILL_KACHI_TAX_FREE("phonebill-kachi", "卡池"),
    ;

    private String code;
    private String desc;

    SupplierProductEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static SupplierProductEnum getByCode(String code) {
        for (SupplierProductEnum supplierProductEnum : SupplierProductEnum.values()) {
            if (supplierProductEnum.getCode().equals(code)) {
                return supplierProductEnum;
            }
        }
        return null;
    }
}
