package cn.com.duiba.goods.center.api.remoteservice.item;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemAppSpecifyDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.Date;
import java.util.List;

/**
 * 商品APP定向后台接口
 */
@AdvancedFeignClient
public interface RemoteItemAppSpecifyBackendService {
	
	/**
	 * 查询没有定向
	 * @param appId
	 * @return
	 */
	public DubboResult<List<Long>> findNOSpecify4App(Long appId);

    /**
     * 查找兑换项的定向关系表
     * @param itemId
     * @return
     */
    public List<ItemAppSpecifyDto> findAllByItemId(Long itemId);

    /**
     * 批量查找兑换项的定向关系表
     * @param itemIds
     * @return
     */
    public List<ItemAppSpecifyDto> batchFindAllByItemIds(List<Long> itemIds);

    /**
     * 查找商品id
     * @param appId
     * @return ItemIds
     */
    List<Long> findItemIdsByAppId(Long appId);

    /**
     * 删除定向关系
     * @param id
     */
    public void delete(Long id);

    /**
     * insert
     * @param itemAppSpecifyDO
     */
    public void insert(ItemAppSpecifyDto itemAppSpecifyDO);

    /**
     * find
     * @param id
     * @return
     */
    public ItemAppSpecifyDto find(Long id);

    /**
     * updateRemaining
     * @param id
     * @param remaining
     */
    public void updateRemaining(Long id, Integer remaining);

    /**
     * 找出不是该APP的（后台新加的开发者未浏览过的）定向商品
     * @param appId
     * @return
     */
    public List<Long> findNOSpecify4AppNew( Long appId, Date newItemTime);

    /**
     * reduceRemaining
     * @param itemId
     * @param appId
     * @return
     */
    public int reduceRemaining(Long itemId,Long appId);

    /**
     * increaseRemaining
     * @param itemId
     * @param appId
     * @return
     */
    public int increaseRemaining( Long itemId,Long appId);

    /**
     * findByItemIdAndAppIdLock
     * @param itemId
     * @param appId
     * @return
     */
    public ItemAppSpecifyDto findByItemIdAndAppIdLock(Long itemId,Long appId);

}
