package cn.com.duiba.goods.center.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsCopyRelationDto;


import java.util.List;

@AdvancedFeignClient
public interface RemoteGoodsCopyRelationService {

	Integer save(GoodsCopyRelationDto goodsCopyRelationDto) throws BizException;

    void deleteById(Long id) throws BizException;

    void deleteBatchByIds(List<Long> ids) throws BizException;

    Integer updateById(GoodsCopyRelationDto goodsCopyRelationDto) throws BizException;

    GoodsCopyRelationDto getById(Long id) throws BizException;

    List<GoodsCopyRelationDto> getByOriginItemId(Long originItemId) throws BizException;

    GoodsCopyRelationDto getByItemId(Long originItemId);

    List<GoodsCopyRelationDto> listByIds(List<Long> ids) throws BizException;

}
