package cn.com.duiba.goods.center.api.remoteservice.enums;

import org.apache.commons.lang.StringUtils;

/**
 * 虚拟商品渠道枚举
 *
 * @author zouweixiang
 * @date 2021/07/17
 */
public enum VisualItemChannelEnum {


    /**
     * 虚拟商品充值渠道状态码
     */
    FULU("fulu", "福禄"),
    HUAZHU("huazhu", "华住"),
    BILIBILI("bilibili", "哔哩哔哩"),
    PU_SHANG("pushang", "浦上"),
    SHANG_YU("shangyu", "尚娱"),
    QING_TIAN("qingtian", "晴天"),
    ALIPAY_IGR("alipayIGR", "杭州兑吧支付宝立减金"),
    FJ_DB_WXLJJ("fjdbwxljj", "福建兑吧微信立减金"),
    DB_FJ_WXLJJ("dbfjwxljj", "兑吧福建微信立减金"),
    DB_FJ_WXLJJ_002("dbfjwxljj002", "兑吧福建微信立减金002"),
    ANHUI_DB_WXLJJ_002("ahdbwxljj002", "安徽兑吧微信立减金002"),
    FUJIAN_DUIBA_ALIPAY_IGR("fujianDuibaAlipayIGR", "福建兑吧支付宝立减金"),
    DUIBA_FUJIAN_ALIPAY_IGR("duibaFujianAlipayIGR", "兑吧福建支付宝立减金"),
    PS_WX_RED_PACKET("psWxRedPacket", "浦上微信红包"),
    PS_ALIPAY_CHARGE("psAlipayCharge", "浦上支付宝直充"),
    JIGAO("jigao", "继皋"),
    YI_PAI("yipai", "易派"),
    HLX("hlx", "和路雪"),
    WX_REDPACK("wxRedpack", "微信红包"),
    IQIYI_MEMBER("iqiyiMember", "爱奇艺会员"),
    DEDAO("dedao", "得到"),
    MIGU("migu", "咪咕"),
    SANLU("sanlu", "叁陆"),
    PUMAI("pumai", "普麦"),
    HANGLVZONGHENG("hanglvzongheng", "航旅纵横"),
    DINGXIN_COUPON("dingxinCoupon", "鼎信-卡券"),
    DINGXIN_CHARGE("dingxinCharge", "鼎信-直冲"),
    YOUKU_CHARGE("youkuCharge", "优酷直充"),
    YINSHENGSHUHUI_CHARGE_COUPON1("yinshengshuhuiChargeCoupon1", "银盛数惠充值：美团到店/美团立减金/支付宝立减金"),
    SHENGMA_CHARGE("shengmaCharge", "盛马直充"),
    ANYI_CHARGE("anyiCharge", "安怡直充"),
    HAORAN_CHARGE("haoranCharge", "淏然直充"),
    XIMALAYA_MEMBER("ximalayaMember", "喜马拉雅会员"),
    YANXUAN_MEMBER("yanxuanMember", "网易严选会员"),
    YIN_LIAN("yinlian", "银联"),
    DUI_BA_CORNUCOPIA("duibacornucopia", "聚宝盆权益"),
    YINGE_TEST("yingeTest", "印鸽测试"),
    /*SUCCESS("success","成功"),
    FAIL("fail","失败"),
    TIME_OUT("timeout","超时"),*/
    ;

    String code;
    String desc;

    VisualItemChannelEnum(String code, String desc){
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    /**
     * 根据code获取描述
     *
     * @param code
     * @return
     */
    public static String getDescByCode(String code) {
        for (VisualItemChannelEnum channelEnum : VisualItemChannelEnum.values()) {
            if (StringUtils.equals(channelEnum.getCode(), code)) {
                return channelEnum.getDesc();
            }
        }
        return null;
    }


}
