package cn.com.duiba.goods.center.api.remoteservice.item;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.AppItemTopDto;

import java.util.List;

/**
 * 置顶商品服务
 *
 * @Author: xuwei
 * @Date: 2019/7/26 11:59
 */
@AdvancedFeignClient
public interface RemoteAppItemTopService {

    /**
     * 商品置顶
     *
     * @param record
     * @return
     */
    Long insert(AppItemTopDto record);

    /**
     * 取消置顶
     *
     * @param appItemId
     */
    void cancel(Long appItemId);

    /**
     * 根据商品ID获取
     *
     * @param appItemId
     * @return
     */
    AppItemTopDto findByAppItemId(Long appItemId);

    /**
     * 根据商品ID列表查询
     *
     * @param appItemIds
     * @return
     */
    List<AppItemTopDto> findByAppItemIds(List<Long> appItemIds);

    /**
     * 获取APP下最大排序值
     *
     * @param appId
     * @return
     */
    Integer findAppMaxPayload(Long appId);

    /**
     * 更新排序值
     *
     * @param id
     */
    void updatePayload(Long id, int payload);

    /**
     * 批量增加app下指定排序值之后的排序值
     *
     * @param appId
     * @param minPayload 最小排序值，会对 大于等于 该值的记录 排序值+1
     */
    void batchIncreasePayload(Long appId, int minPayload);

    /**
     * 批量减少app下指定排序值之前的排序值
     *
     * @param appId
     * @param maxPayload 最大排序值，会对 小于等于 该值的记录 排序值-1
     */
    void batchDecreasePayload(Long appId, int maxPayload);
}
