package cn.com.duiba.goods.center.api.remoteservice.stockwarn;

import cn.com.duiba.api.bo.page.Page;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.goods.center.api.remoteservice.dto.stockwarn.ItemStockWarnRuleItemDto;

import java.util.List;

/**
 * 兑换管理后台商品库存告警规则商品服务
 */
@AdvancedFeignClient
public interface RemoteItemStockWarnRuleItemService {

    /**
     * 新增
     */
    Long insert(ItemStockWarnRuleItemDto itemStockWarnRuleItemDto);

    /**
     * 删除
     */
    boolean delete(int id);

    /**
     * 更新
     */
    Long update(ItemStockWarnRuleItemDto itemStockWarnRuleItemDto);

    /**
     * 根据规则Id 查询
     */
    List<ItemStockWarnRuleItemDto> loadByRuleId(long ruleId);

    /**
     * 根据规则id分页查询
     * @param ruleId
     * @param pageNo
     * @param pageSize
     * @return
     */
    Page<ItemStockWarnRuleItemDto> pageByRuleId(Long ruleId, Integer pageNo, Integer pageSize);
}
