package cn.com.duiba.goods.center.api.remoteservice.tool;

import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemKeyDto;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang.StringUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * appitem extraInfo字段工具类
 * Created by sunyan on 2017/8/18.
 */
public class ExtraInfoUtils {

    public static final String BIZ_CREDITS="bizCredits";
    public static final String BUTTON_TEXT="buttonText";//兑换按钮文字（默认'马上兑换'）
    public static final String LABEL="label";//商品标签
    public static final String SECKILL_PHONE_LIMIT = "seckillLimit"; //是否开启秒杀充值电话号码限制
    //南宁中信，自有商品打标对应哪个供应商
    public static final String SUPPLIER_TAG = "supplierTag";
    //满赠赠品id
    public static final String BONUS_ITEM_ID = "bonusItemId";
    //满赠赠品订单id
    public static final String BONUS_ORDER_ID = "bonusOrderId";
    //农总行商品库，三级类目id
    public static final String CMDY_CATE_LEVEL = "cmdyCateLevel";
    // 汇丰 库存告警邮箱
    public static final String STOCK_WARN_EMAIL = "stockWarnEmailList";
    // 汇丰 库存告警下限
    public static final String STOCK_WARN_LOWER_LIMIT = "stockWarnLowerLimit";
    // 央视频-组件推荐入口开关(false-关闭 true-打开 默认false)
    public static final String RECOMMEND_ENTER_SWITCH = "recommendEnterSwitch";
    // 央视频-组件推荐入口展示文案
    public static final String RECOMMEND_ENTER_TEXT = "recommendEnterText";
    // 央视频-组件推荐入口跳转链接
    public static final String RECOMMEND_ENTER_LINK = "recommendEnterLink";


    private ExtraInfoUtils(){
        //do nothing
    }

    /**
     * 扩展积分
     * @param itemKeyDto
     * @return
     */
    public static String getBizCredits(ItemKeyDto itemKeyDto){
        if (itemKeyDto.getAppItem()!=null) {
            return getBizCredits(itemKeyDto.getAppItem().getExtraInfo());
        }
        return null;
    }

    /**
     * 扩展积分
     * @param extraInfo
     * @return
     */
    public static String getBizCredits(String extraInfo){
        if (StringUtils.isNotBlank(extraInfo)) {
            JSONObject json = JSONObject.parseObject(extraInfo);
            return json.getString(BIZ_CREDITS);
        }
        return null;
    }

    /**
     * 按key获取value
     * @param extraInfo
     * @return
     */
    public static String getValue(String extraInfo,String key){
        if (StringUtils.isNotBlank(extraInfo)) {
            JSONObject json = JSONObject.parseObject(extraInfo);
            return json.getString(key);
        }
        return null;
    }

    /**
     * 商品供应商
     */
    public static Integer getSupplierTag(String extraInfo) {
        if (StringUtils.isNotBlank(extraInfo)) {
            JSONObject json = JSONObject.parseObject(extraInfo);
            return json.getInteger(SUPPLIER_TAG);
        }
        return null;
    }

    /**
     * 库存告警邮件
     * @param extraInfo
     * @return
     */
    public static List<String> getGoodStockWarnEmails(String extraInfo){
        if (StringUtils.isBlank(extraInfo)) {
            return new ArrayList<>();
        }
        return JSONObject.parseObject(extraInfo).getJSONArray(STOCK_WARN_EMAIL).toJavaList(String.class);
    }

    /**
     * 库存告警下限
     * @param extraInfo
     * @return
     */
    public static Integer getGoodStockWarnLowerLimit(String extraInfo){
        if (StringUtils.isBlank(extraInfo)) {
            return null;
        }
        return JSONObject.parseObject(extraInfo).getInteger(STOCK_WARN_LOWER_LIMIT);
    }
}
