package cn.com.duiba.goods.center.api.remoteservice.dto.item;

import org.apache.commons.lang3.builder.ToStringBuilder;

import java.io.Serializable;
import java.util.Date;

/**
 * Created by xutao on 2018/11/5.
 */
public class ItemLimitConfigDto implements Serializable {

    private static final long serialVersionUID = 2852063191179490059L;
    private Long id;

    private Long appItemId;

    private Long itemId;

    //用户兑换限制范围(每天,天或者永久)
    private String limitScope;

    //兑换限制数量
    private Integer limitCount;

    //会员限制配置数据
    private Long vipLimits;

    //会员限制类型
    private Integer vipLimitType;

    private Date gmtCreate;

    private Date gmtModified;

    //账户兑换限制范围(每天,天或者永久)
    private String accountLimitScope;

    //账户兑换限制数量
    private Integer accountLimitCount;

    public String getAccountLimitScope() {
        return accountLimitScope;
    }

    public void setAccountLimitScope(String accountLimitScope) {
        this.accountLimitScope = accountLimitScope;
    }

    public Integer getAccountLimitCount() {
        return accountLimitCount;
    }

    public void setAccountLimitCount(Integer accountLimitCount) {
        this.accountLimitCount = accountLimitCount;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getAppItemId() {
        return appItemId;
    }

    public void setAppItemId(Long appItemId) {
        this.appItemId = appItemId;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public String getLimitScope() {
        return limitScope;
    }

    public void setLimitScope(String limitScope) {
        this.limitScope = limitScope;
    }

    public Integer getLimitCount() {
        return limitCount;
    }

    public void setLimitCount(Integer limitCount) {
        this.limitCount = limitCount;
    }

    public Long getVipLimits() {
        return vipLimits;
    }

    public void setVipLimits(Long vipLimits) {
        this.vipLimits = vipLimits;
    }

    public Integer getVipLimitType() {
        return vipLimitType;
    }

    public void setVipLimitType(Integer vipLimitType) {
        this.vipLimitType = vipLimitType;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    public static ItemLimitConfigDto convertOldItemDto(ItemDto dto) {
        if (dto == null) {
            return null;
        }
        ItemLimitConfigDto itemLimitConfigDto = new ItemLimitConfigDto();
        itemLimitConfigDto.setItemId(dto.getId());
        itemLimitConfigDto.setLimitCount(dto.getLimitCount());
        itemLimitConfigDto.setLimitScope(dto.getLimitScope());
        return itemLimitConfigDto;
    }
}
