package cn.com.duiba.goods.center.api.remoteservice.item;

import cn.com.duiba.api.bo.page.Page;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.AppItemCreditsSkuDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.AppItemDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.AppItemPageQueries;
import cn.com.duiba.goods.center.api.remoteservice.param.AppItemSkuRemainingParam;
import cn.com.duiba.goods.center.api.remoteservice.param.SupplyItemQueryParam;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;
import java.util.Map;

/**
 * 开发者商品相关服务
 * 
 * @author houwen
 */
@AdvancedFeignClient
public interface RemoteAppItemGoodsService {

	/**
	 * 根据ID查询应用商品信息
	 * 
	 * @param id
	 * @return
	 */
	public DubboResult<AppItemDto> find(Long id);
	
	/**
	 * 根据APPid和兑吧商品ID查询开发者商品
	 * @param appId
	 * @param itemId
	 * @return
	 */
	public DubboResult<AppItemDto> findByAppAndItem(Long appId, Long itemId);

	/**
	 * 根据APPid和兑吧商品IDs查询开发者商品
	 * @param appId
	 * @param itemIds
	 * @return
	 */
	public DubboResult<List<AppItemDto>> findByAppAndItems(Long appId, List<Long> itemIds);

	/**
	 * 根据APPid和兑吧商品ID查询开发者商品上架的
	 * @param appId
	 * @param itemId
	 * @return
	 */
	public DubboResult<AppItemDto> findByAppAndItemOnline(Long appId, Long itemId);
	
	/**
	 * 获取banner对应商品项(缓存,缺省字段)
	 * 
	 * @param appId
	 * @param appItems
	 * @return
	 */
    public DubboResult<List<AppItemDto>> findBannerIconAppItemByCache(Long appId,List<Long> appItems);

	/**
	 * 根据ID集合查询应用商品信息
	 *
	 * @param ids
	 * @return
	 */
	public DubboResult<List<AppItemDto>> findByIds(List<Long> ids);

	/**
	 * 条件查询应用商品信息
	 * @param queries
	 * @return
	 */
	List<AppItemDto> findByCondition(AppItemPageQueries queries);

	/**
	 * 根据ID集合查询应用商品信息 没有库存信息
	 * @param ids
	 * @return
	 * @throws BizException
	 */
	List<AppItemDto> findByIdsWithoutSkuStock(List<Long> ids) throws BizException;
	
	/**
	 * 根据RelationId批量查询AppItemId
	 * @return
	 */
	public DubboResult<List<Long>> findIDbySourceIdsAndSourceTypes(List<Long> sourceIds, List<Integer> sourceTypes);

	/**
	 * findBySourceIdsAndSourceTypes
	 * @param sourceIds
	 * @param sourceTypes
	 * @param appId
	 * @return
	 */
	public DubboResult<List<AppItemDto>> findBySourceIdsAndSourceTypes(List<Long> sourceIds, List<Integer> sourceTypes, Long appId);

	/**
	 * 手机端分页查询商品
	 * @param appId
	 * @param queryParams
	 * @return
	 */
	public DubboResult<List<AppItemDto>> findByLimitCache(Long appId, Map<String, Object> queryParams);
	
	/**
	 * 查询APP商品最大的排序
	 * @param appId
	 * @return
	 */
	public DubboResult<Integer> findAppMaxPayload(Long appId);
	
	/**
	 * 创建商品
	 * 
	 * @param appItemDto
	 * @return
	 */
	public DubboResult<Long> insert(AppItemDto appItemDto);

	/**
	 * 修改商品
	 * ⚠ 该方法会将version直接设置为0
	 * @param appItemDto
	 * @return
	 */	
	public DubboResult<Boolean> update(AppItemDto appItemDto);

	/**
	 * 修改商品
	 * 俺需修改
	 * @param appItemDto
	 * @return
	 */
	public DubboResult<Boolean> updateNew(AppItemDto appItemDto);

	/**
	 * 删除商品
	 * 执行玩删除后需要调用： DuibaEventsDispatcher.get().dispatchEvent(new ItemEvent(ItemEvent.ItemEventType.onDeleted, key));
	 * @param appId
	 * @param appItemId
	 * @return
	 */
	public DubboResult<Boolean> delete(Long appId, Long appItemId);

	/**
	 * 批量删除商品
	 * 
	 * @param appId
	 * @param appItemIds
	 * @return
	 */
	public DubboResult<Integer> deleteByIds(Long appId, List<Long> appItemIds);

	/**
	 * 修改状态
	 * 
	 * @param appId
	 * @param appItemId
	 * @param status
	 *            off:下架 on:上架
	 * @return
	 */
	public DubboResult<Boolean> updateStatus(Long appId, Long appItemId, String status);

	/**
	 * 批量修改状态
	 * 
	 * @param appId
	 * @param appItemIds
	 * @param status
	 *            off:下架 on:上架
	 * @return
	 */
	public DubboResult<Integer> updateStatusByIds(Long appId, List<Long> appItemIds, String status);

	/**
	 * 编辑商品，增加库存
	 * @param appId
	 * @param appItemId
	 * @param number
	 * @return
	 */
	public DubboResult<Boolean> appendStock(Long appId, Long appItemId, Long number);

	/**
	 * 编辑商品，减少库存
	 * @param appId
	 * @param appItemId
	 * @param number
	 * @return
	 */
	public DubboResult<Boolean> deductStock(Long appId, Long appItemId, Long number);

	/**
	 * 根据releationID批量修改状态
	 * @param status
	 * @param delete
	 * @param oids
	 * @return
	 */
    public DubboResult<Integer> updateStatusByActivityIds(String status, Boolean delete, List<Long> oids);

	/**
	 * 根据活动ID更新状态
	 */
	public DubboResult<Integer> updateStatusByActivityId(String status, Boolean delete, List<Long> relationIds);

	/**
	 * 批量修改商品
	 * 最多支持一次批量更新50条, else 抛出异常提示
	 * @param appItemDtos
	 * @return
	 */
	DubboResult<Boolean> updateItems(List<AppItemDto> appItemDtos);

	/**
	 * 根据app_id、type、source_relation_id、source_type批量修改积分价值
	 * @param appItemDtos
	 * @return
	 */
	void batchUpdateItemByAppIdAndTypeAndSourceRelationId(List<AppItemDto> appItemDtos);

	/**
	 * 根据app_id、type、source_relation_id、source_type修改积分价值
	 * @param appItemDto
	 * @return
	 */
	void updateItemByAppIdAndTypeAndSourceRelationId(AppItemDto appItemDto);

	/**
	 * 查询商品库存信息
	 *
	 * @param ids
	 * @return
	 * @throws BizException
	 */
	Map<Long, Integer> findRemainingByIds(List<Long> ids);

	/**
	 * 根据appItem列查询所有sku维度的库存,会根据appId过滤非当前app的商品
	 * 新商品返回sku维度的库存
	 * 老商品会构建一个skuId为零的返回对象
	 * @param appItemIds
	 * @param appId
	 * @return
	 */
	List<AppItemSkuRemainingParam> findRemainingByAppItemIdsAndAppId(List<Long> appItemIds, Long appId);

	/**
	 * 分页查询当前app有效的采购商品，返回appItemId列表
	 * 1.兑吧商品，过滤京东供应商提供的商品
	 * 2.上架
	 * 3.未删除
	 * 4.实物或优惠券
	 * 5.按照商品入库时间 进行倒序排列
	 */
	Page<Long> findValidIdsForSupply(SupplyItemQueryParam param);

	/**
	 * 分页查询根据ItemIds列表过滤 返回有效appItemId列表
	 * 1.兑吧商品，过滤京东供应商提供的商品
	 * 2.上架
	 * 3.未删除
	 * 4.实物或优惠券
	 * 5.按照商品入库时间 进行倒序排列
	 */
	Page<Long> findValidIdsForSupplyByItemIds(SupplyItemQueryParam param);

    /**
     * 获取置顶商品最小排序值
     *
     * @param appId
     * @return
     */
    int findAppMinTopPayload(Long appId);

	/**
	 * 入库商品主表简单信息分页查询（无库存，sku，限制，详情描述等子表信息）
	 *
	 * @param queries
	 * @return
	 */
	cn.com.duiba.goods.center.api.remoteservice.tool.Page<AppItemDto> simplePage(AppItemPageQueries queries, boolean withTotal);

	/**
	 * 批量查询商品积分换购sku
	 * @param appItems
	 * @return
	 */
	List<AppItemCreditsSkuDto> selectAppItemCreditsSkuList(List<AppItemDto> appItems,Integer creditsRate);


	/**
	 * 根据appId 查询 自有 实物 app_item.id列表
	 * @param appId
	 * @return
	 */
	List<Long> listIdsByAppId(Long appId);


	/**
	 *
	 * @param appId 应用id
	 * @param type 商品类型
	 * @param selfFlag 是否是自有商品：0：不限制 1：兑吧商品 2：自有商品
	 * @return
	 */
	List<Long> listIdsByAppIdAndTypeAndSelf(Long appId, String type, Integer selfFlag);

}
