package cn.com.duiba.goods.center.api.remoteservice.dto.supplier;

import cn.com.duiba.goods.center.api.remoteservice.dto.AddrLimitDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemDescConfigDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemExtraDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.sku.ItemSkuDto;

import java.io.Serializable;
import java.util.List;

/**
 * @author duiba
 */
public class SupplierDTO implements Serializable {
    private static final long serialVersionUID = 1969481179759496262L;

    /**
     * 商品基础信息
     */
    private ItemDto itemDto;
    /**
     * 商品待发货文案、商品详情、主图信息等
     */
    private ItemDescConfigDto itemDescConfigDto;
    /**
     * 商品SKU信息等
     */
    private List<ItemSkuDto> itemSkuDTOs;
    /**
     * 商品地域限制信息
     */
    private List<AddrLimitDto> addLimitDTOs;
    /**
     * 商品扩展信息
     */
    private ItemExtraDto  itemExtraDto;

    public ItemDto getItemDto() {
        return itemDto;
    }

    public void setItemDto(ItemDto itemDto) {
        this.itemDto = itemDto;
    }

    public ItemDescConfigDto getItemDescConfigDto() {
        return itemDescConfigDto;
    }

    public void setItemDescConfigDto(ItemDescConfigDto itemDescConfigDto) {
        this.itemDescConfigDto = itemDescConfigDto;
    }


    public List<ItemSkuDto> getItemSkuDTOs() {
        return itemSkuDTOs;
    }

    public void setItemSkuDTOs(List<ItemSkuDto> itemSkuDTOs) {
        this.itemSkuDTOs = itemSkuDTOs;
    }

    public List<AddrLimitDto> getAddLimitDTOs() {
        return addLimitDTOs;
    }

    public void setAddLimitDTOs(List<AddrLimitDto> addLimitDTOs) {
        this.addLimitDTOs = addLimitDTOs;
    }

    public ItemExtraDto getItemExtraDto() {
        return itemExtraDto;
    }

    public void setItemExtraDto(ItemExtraDto itemExtraDto) {
        this.itemExtraDto = itemExtraDto;
    }
}
