package cn.com.duiba.goods.center.api.remoteservice.couponcode;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.goods.center.api.remoteservice.dto.couponcode.CouponCodeDto;

import java.util.List;
import java.util.Map;

@AdvancedFeignClient
public interface RemoteCouponCodeOperationService {

    public int batchInsert(List<CouponCodeDto> codeList);

    public int batchDelete(List<Long> codeList);

    public int batchUpdate(List<CouponCodeDto> codeList);
    
    public int batchUpdateWithStatus(List<Long> ids, String lockKey, Integer status);

    public List<CouponCodeDto> findCouponCodeList(Map<String, Object> queryMap);

    public Long findCouponCodeListCount(Map<String, Object> queryMap);

    public String findCouponCodeByBatchIdAndCouponCode(Long batchId, String couponCode);

    public List<CouponCodeDto> findAll(Long batchId);

    public int deleteByCodeId(Long codeId);

    public CouponCodeDto findByCodeId(Long codeId);


    public List<CouponCodeDto> findByBatchIdAndLimit(Long batchId, Integer limit);
}
