package cn.com.duiba.goods.center.api.remoteservice.item;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemExtraDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;
import java.util.Map;

/**
 * 
 * ItemExtraService
 *
 */
@AdvancedFeignClient
public interface RemoteItemExtraService {

	/**
	 * findByItemId
	 * @param itemId
	 * @return
	 */
    DubboResult<ItemExtraDto> findByItemId(Long itemId);

    /**
     * findByItemIds
     * @param itemIds
     * @return
     */
    DubboResult<List<ItemExtraDto>> findByItemIds(List<Long> itemIds);

    /**
     * findByName4Admin
     * @param name
     * @return
     */
    DubboResult<List<ItemExtraDto>> findByName4Admin(String name);

    /**
     * insert
     * @param itemExtra
     * @return 更新行数
     */
    DubboResult<Integer> insert(ItemExtraDto itemExtra);

    /**
     * update
     * @param itemExtra
     * @return 更新行数
     */
    DubboResult<Integer> update(ItemExtraDto itemExtra);

    /**
     * 取ItemExtra信息，比如图片
     * 格式：[key: value] = [itemId, ItemExtraDto]
     * @param itemIds
     * @return
     */
    DubboResult<Map<Long, ItemExtraDto>> getItemExtraDtoMap(List<Long> itemIds);

    /**
     * findALL
     * @return
     */
    public List<ItemExtraDto> findAll();

}
