package cn.com.duiba.goods.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.goods.center.api.remoteservice.dto.zhanyi.ZYCouponDataDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.zhanyi.ZYCouponRecordDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.zhanyi.ZYItemDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/** 
 * @author sunyan
 * @version 创建时间：2017年5月18日 上午11:07:45
 */
@AdvancedFeignClient
public interface RemoteBrandCouponGoodsBackendService {
    /**
     * 获取展翼优惠券列表
     * @param itemName 优惠券名
     * @return
     */
    public DubboResult<List<ZYItemDto>> getZYCouponList(String itemName);
    /**
     * 
     * @param itemName 优惠券名
     * @param itemPrice 优惠券名
     * @param itemId 优惠券id
     * @param count 购买数量
     * @return
     * 获取展翼优惠券列表
     */
    public DubboResult<ZYCouponDataDto> getZYCoupon(String itemName,String itemPrice,String itemId,Integer count);

    /**
     * 分页查询购买记录
     * @param itemName 优惠券名
     * @param start
     * @param pageSize
     * @return
     */
    public DubboResult<List<ZYCouponRecordDto>> findCouponPage(String itemName,Integer start,Integer pageSize);
    
    /**
     * 分页查询购买记录总数
     * @param itemName 优惠券名
     * @param start
     * @param pageSize
     * @return
     */
    public DubboResult<Integer> findCouponPageCount(String itemName);
    
    /**
     * 更新下载链接
     * @param id
     * @param filePath
     * @return
     */
    public DubboResult<Integer> updateFilePath(Long id,String filePath);
}
