package cn.com.duiba.goods.center.api.remoteservice.banner;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.goods.center.api.remoteservice.dto.banner.PlatformBannerEditDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.banner.PlatformBannerPageDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.banner.PlatformBannerSaveDto;
import cn.com.duiba.goods.center.api.remoteservice.tool.Page;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * 提供给管理员后台操作接口
 */
@AdvancedFeignClient
public interface RemotePlatformBannerBackendService {

    /**
     * 管理员后台,banner 分页查询
     * @param current
     * @param pageSize
     * @param bizCode
     * @return
     */
    DubboResult<Page<PlatformBannerPageDto>> findPlatformBannersPage(int current, int pageSize, int bizCode);

    /**
     * 管理员后台,banner 启用
     * @param bannerId
     * @return
     */
    DubboResult<Boolean> enable(Long bannerId);

    /**
     * 管理员后台,banner 禁用
     * @param bannerId
     * @return
     */
    DubboResult<Boolean> disable(Long bannerId);

    /**
     * 管理员后台,banner 删除
     * @param bannerId
     * @return
     */
    DubboResult<Boolean> delete(Long bannerId);

    /**
     * 管理员后台,banner 编辑
     * @param bannerId
     * @return
     */
    DubboResult<PlatformBannerEditDto> findPlatformBanner4Edit(Long bannerId);

    /**
     * 管理员后台,banner 创建/保存
     * @param pbSaveDto
     * @param bizCode
     * @return
     */
    DubboResult<Boolean> save(PlatformBannerSaveDto pbSaveDto, int bizCode);
}
