package cn.com.duiba.goods.center.api.remoteservice.stockwarn;

import cn.com.duiba.api.bo.page.Page;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.goods.center.api.remoteservice.dto.stockwarn.ItemStockWarnRuleDto;

/**
 * 兑换管理后台商品库存告警规则服务
 */
@AdvancedFeignClient
public interface RemoteItemStockWarnRuleService {

    /**
     * 新增
     */
    Long insert(ItemStockWarnRuleDto itemStockWarnRuleDto);

    /**
     * 删除
     */
    boolean delete(int id);

    /**
     * 更新
     */
    Long update(ItemStockWarnRuleDto itemStockWarnRuleDto);

    /**
     * 根据主键 id 查询
     */
    ItemStockWarnRuleDto load(int id);

    /**
     * 分页查询
     */
    Page<ItemStockWarnRuleDto> pageList(int pageNo, int pageSize);
}
