package cn.com.duiba.goods.center.api.remoteservice.supplier;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.goods.center.api.remoteservice.dto.WdtSupplierApiConfigDto;

import java.util.List;

/**
 * 旺店通供应商API配置远程服务接口
 * 
 * @author cgq
 * @date 2024-12-19
 */
@AdvancedFeignClient
public interface RemoteWdtSupplierApiConfigService {

    /**
     * 根据ID查询
     * 
     * @param id 主键ID
     * @return 旺店通供应商API配置DTO
     */
    WdtSupplierApiConfigDto findById(Long id);

    /**
     * 根据供应商ID查询
     * 
     * @param supplierId 供应商ID
     * @return 旺店通供应商API配置DTO
     */
    WdtSupplierApiConfigDto findBySupplierId(Long supplierId);

    /**
     * 根据供应商ID列表批量查询
     * 
     * @param supplierIds 供应商ID列表
     * @return 旺店通供应商API配置DTO列表
     */
    List<WdtSupplierApiConfigDto> findBySupplierIds(List<Long> supplierIds);

    /**
     * 查询所有旺店通供应商API配置
     * 
     * @return 旺店通供应商API配置DTO列表
     */
    List<WdtSupplierApiConfigDto> findAll();
}
