package cn.com.duiba.goods.center.api.remoteservice.item;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemDisableLogDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * Created by wenqi.huang on 16/4/27.
 */
@AdvancedFeignClient
public interface RemoteItemDisableLogBackendService {

    /**
     * 根据ID查询单个记录
     */
    public DubboResult<ItemDisableLogDto> find(Long id);

    /**
     * 根据ID删除行
     */
    public DubboResult<Integer> delete(Long id);

    /**
     * 插入
     */
    public DubboResult<Integer> insert(ItemDisableLogDto dto);

    /**
     * 根据itemId获取禁用日志
     */
    public DubboResult<List<ItemDisableLogDto>> findAllByItemId(Long itemId);
}
