package cn.com.duiba.goods.common.enums;

import cn.com.duiba.goods.common.exception.EnumNotFoundException;

/**
 * 快递公司类型
 * Created by guoyanfei .
 * 2022/12/27 .
 */
public enum ExpressCompanyType {

    DOMESTIC(1, "国内运输商"),
    INTERNATIONAL(2, "国际运输商"),
    INTERNATIONAL_POST(3, "国际邮政");

    private int type;

    private String value;

    ExpressCompanyType(int type, String value) {
        this.type = type;
        this.value = value;
    }

    public int getType() {
        return type;
    }

    public String getValue() {
        return value;
    }

    public static ExpressCompanyType getByValue(String value) {
        for (ExpressCompanyType it : ExpressCompanyType.values()) {
            if (it.getValue().equals(value)) {
                return it;
            }
        }
        throw new EnumNotFoundException("ExpressCompanyType value={}", value);
    }
}
