package cn.com.duiba.goods.common.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * 快递100的状态枚举
 */
public enum ExpressStateEnum {

    STATE_0(0, "在途"),
    STATE_1(1, "揽收"),
    STATE_2(2, "疑难"),
    STATE_3(3, "签收"),
    STATE_4(4, "退签"),
    STATE_5(5, "派件"),
    STATE_6(6, "退回"),
    STATE_7(7, "转投"),
    STATE_10(8, "清关"),
    STATE_14(14, "拒签");

    private final int state;

    private final String desc;

    ExpressStateEnum(int state, String desc) {
        this.state = state;
        this.desc = desc;
    }

    public int getState() {
        return state;
    }

    public String getDesc() {
        return desc;
    }

    private static Map<Integer, String> map = new HashMap<>();

    static {
        for (ExpressStateEnum value : values()) {
            map.put(value.getState(), value.getDesc());
        }
    }

    public static String getByState(Integer state) {
        return map.get(state);
    }
}
