package cn.com.duiba.goods.common.enums.goods;

import cn.com.duiba.goods.common.enums.BaseEnum;
import cn.com.duiba.goods.common.exception.EnumNotFoundException;

/**
 * 七天无理由退货枚举
 * Created by guoyanfei .
 * 2022/11/14 .
 */
public enum SevenDaysNoReason implements BaseEnum {

    NO(0, "不支持"),
    YES(1, "支持");

    private final int code;

    private final String desc;

    SevenDaysNoReason(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public int code() {
        return code;
    }

    @Override
    public String desc() {
        return desc;
    }

    public static SevenDaysNoReason getByCode(int code) {
        for (SevenDaysNoReason it : SevenDaysNoReason.values()) {
            if (it.code() == code) {
                return it;
            }
        }
        throw new EnumNotFoundException(code, "SevenDaysNoReason");
    }

}
