package cn.com.duiba.goods.common.enums.goods;

import cn.com.duiba.goods.common.enums.BaseEnum;
import cn.com.duiba.goods.common.exception.EnumNotFoundException;

/**
 * 发货方式
 * Created by guoyanfei .
 * 2023/1/10 .
 */
public enum ShipType implements BaseEnum {

    MANUAL(1, "手动"),
    AUTO(2, "自动");

    private final int code;

    private final String desc;

    ShipType(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public int code() {
        return code;
    }

    @Override
    public String desc() {
        return desc;
    }

    public static ShipType getByCode(int code) {
        for (ShipType it : ShipType.values()) {
            if (it.code() == code) {
                return it;
            }
        }
        throw new EnumNotFoundException(code, "ShipType");
    }

}
