package cn.com.duiba.goods.common.enums.goods;

import cn.com.duiba.goods.common.enums.BaseEnum;
import cn.com.duiba.goods.common.exception.EnumNotFoundException;

import java.util.Objects;

/**
 * SPU类型枚举
 * @date 2022/11/14
 * @author guoyanfei
 */
public enum SpuType implements BaseEnum {

    OBJECT(1, "实物"),
    WX_COUPON(2, "微信立减金"),
    ALIPAY_COUPON(3, "支付宝立减金"),
    I_QI_YI_ZC(4, "爱奇艺直充"),
    ;

    private final int code;

    private final String desc;

    SpuType(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public int code() {
        return code;
    }

    @Override
    public String desc() {
        return desc;
    }

    public boolean isVirtual() {
        return this != OBJECT;
    }
    
    public static boolean isVirtualSpuType(Integer code) {
        return !Objects.equals(OBJECT.code(), code);
    }
    
    public static SpuType getByCode(int code) {
        for (SpuType it : SpuType.values()) {
            if (it.code() == code) {
                return it;
            }
        }
        throw new EnumNotFoundException(code, "SpuType");
    }

}
