package cn.com.duiba.goods.common.enums.order;

import cn.com.duiba.goods.common.enums.BaseEnum;
import cn.com.duiba.goods.common.exception.EnumNotFoundException;

/**
 * 订单表的 orderStatus 字段枚举
 * Created by guoyanfei .
 * 2022/12/14 .
 */
public enum OrderStatus implements BaseEnum {

    CREATED(0, "已下单"),
    UNSHIPPED(1, "待发货"),
    SHIPPED(2, "待收货"),
    COMPLETED(3, "已完成"),
    CANCELED(4, "已取消");

    private final int code;

    private final String desc;

    OrderStatus(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public int code() {
        return code;
    }

    @Override
    public String desc() {
        return desc;
    }

    public static OrderStatus getByCode(int code) {
        for (OrderStatus it : OrderStatus.values()) {
            if (it.code() == code) {
                return it;
            }
        }
        throw new EnumNotFoundException(code, "OrderStatus");
    }
}
