package cn.com.duiba.goods.common.utils;

import cn.com.duiba.goods.common.enums.goods.SpuType;

/**
 * 不同的商品类型处理器
 * Created by guoyanfei .
 * 2023/1/12 .
 */
public final class SpuTypeHandler {

    public interface Handler {
        void handle();
    }

    public static void handler(Integer spuType, Handler objectHandler, Handler virtualHandler) {
        SpuType spuTypeEnum = SpuType.getByCode(spuType);
        handler(spuTypeEnum, objectHandler, virtualHandler);
    }

    public static void handler(SpuType spuType, Handler objectHandler, Handler virtualHandler) {
        if (spuType.isVirtual()) {
            virtualHandler.handle();
            return;
        }
        objectHandler.handle();
    }
}
