/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.common.enums.goods;

import cn.com.duiba.goods.common.enums.BaseEnum;
import cn.com.duiba.goods.common.exception.EnumNotFoundException;
import java.util.Objects;

public enum SpuType implements BaseEnum
{
    OBJECT(1, "\u5b9e\u7269"),
    WX_COUPON(2, "\u5fae\u4fe1\u7acb\u51cf\u91d1"),
    ALIPAY_COUPON(3, "\u652f\u4ed8\u5b9d\u7acb\u51cf\u91d1"),
    I_QI_YI_ZC(4, "\u7231\u5947\u827a\u76f4\u5145"),
    ALIPAY_COUNT_COINS(5, "\u652f\u4ed8\u5b9d\u6570\u5e01\u7ea2\u5305"),
    CCB_COUNT_COINS(6, "\u5efa\u884c\u6570\u5e01\u7ea2\u5305");

    private final int code;
    private final String desc;

    private SpuType(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public int code() {
        return this.code;
    }

    @Override
    public String desc() {
        return this.desc;
    }

    public boolean isVirtual() {
        return this != OBJECT;
    }

    public static boolean isVirtualSpuType(Integer code) {
        return !Objects.equals(OBJECT.code(), code);
    }

    public static SpuType getByCode(int code) {
        for (SpuType it : SpuType.values()) {
            if (it.code() != code) continue;
            return it;
        }
        throw new EnumNotFoundException(code, "SpuType");
    }
}

