/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.common.enums.order;

import cn.com.duiba.goods.common.enums.order.RefundOrderStatus;
import cn.com.duiba.goods.common.enums.order.RefundType;
import cn.com.duiba.goods.common.exception.EnumNotFoundException;

public enum RefundOp {
    OP1(1, "\u4e70\u5bb6\u552e\u540e\u5f85\u5ba1\u6838"),
    OP2(2, "\u5546\u5bb6\u5ba1\u6838\u901a\u8fc7"),
    OP3(3, "\u5546\u5bb6\u5ba1\u6838\u62d2\u7edd"),
    OP4(4, "\u4e70\u5bb6\u4e0a\u4f20\u5355\u53f7"),
    OP5(5, "\u5546\u5bb6\u786e\u8ba4\u6536\u8d27, \u540c\u610f\u9000\u6b3e"),
    OP6(6, "\u4e70\u5bb6\u53d6\u6d88\u552e\u540e");

    private int value;
    private String name;

    private RefundOp(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public int getValue() {
        return this.value;
    }

    public static RefundOp get(RefundOrderStatus refundOrderStatus, RefundType refundType) {
        switch (refundOrderStatus) {
            case CREATED: {
                return OP1;
            }
            case UNSHIPPED: {
                return OP2;
            }
            case SHIPPED: {
                return OP4;
            }
            case COMPLETED: {
                switch (refundType) {
                    case ONLY_REFUND: {
                        return OP2;
                    }
                    case RETURN_AND_REFUND: {
                        return OP5;
                    }
                }
            }
            case REJECTED: {
                return OP3;
            }
            case CANCELED: {
                return OP6;
            }
        }
        throw new EnumNotFoundException("RefundOpName not exist, refundOrderStatus={}, refundType={}", refundOrderStatus, refundType);
    }
}

