package cn.com.duiba.hdtool.center.api.dto.hdtool;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.google.common.collect.Maps;

import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

import static cn.com.duiba.hdtool.center.api.enums.UploadImageEnum.BANNER_IMAGE_NEW;
import static cn.com.duiba.hdtool.center.api.enums.UploadImageEnum.SMALL_IMAGE_NEW;

/**
 * ClassName:DuibaHdtoolService<br/>
 *
 * @author gey
 * @version 1.0
 *
 * 静态变量迁移至 biz-tool   DuibaHdtoolUtil 类中
 * @date 创建时间：2018/3/12  16:45
 * @since JDK 1.8
 **/

public class DuibaHdtoolDto implements Serializable {

	private static final long serialVersionUID = -1692595446834739092L;

	//id
	private Long id;
	//标题
	private String title;
	//type
	private Integer type;
	//模版类型
	private String subType;
	//积分
	private Long creditsPrice;
	//积分价值
	private Double creditsViewPrice;
	//免费抽奖次数
	private Integer freeLimit;
	//免费抽奖范围
	private String freeScope;
	//抽奖限制次数
	private Integer limitCount;
	//抽奖限制范围
	private String limitScope;
	//banner图
	private String bannerImage;
	//缩略图
	private String smallImage;
	//白底缩略图
	private String whiteImage;
	//图标
	private String logo;
	//黑名单开关
	private Long switches;
	//状态
	private Integer status;
	//删除状态
	private Boolean deleted;
	// 概率说明
	private String rateIntroduction;
	//定时自动下架日期
	private Date autoOffDate;
	//定时自动上架日期
	private Date autoOnDate;
	// 推荐位横幅图
	private String recommendImage;
	//免费次数参与的活动规则
	private String freeRule;
	//活动归类
	private Long activityCategoryId;
	//标签json
	private String tag;
	//json图片字符串
	private String imageJson;
	//皮肤id
	private Long duibaBrickId;
	//扩展字段1
	private String extendJson;
	//出奖方式
	private String factoryKey;
	//是否对开发者隐藏
	private Boolean hiddenForDeveloper;
	//加次数限制
	private Integer addTimeLimit;
	//新版首页banner
	protected String bannerImgNew;
	//新版缩略图
	protected String smallImgNew;
	//游戏扩展字段
	private String gameExtendJson;
	/**
     * 投放渠道,发放福袋专用
     */
    private  Integer  channelType;
    //创建时间
    private Date gmtCreate;
    //修改时间
    private Date gmtModified;

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public String getSubType() {
		return subType;
	}

	public void setSubType(String subType) {
		this.subType = subType;
	}

	public Long getCreditsPrice() {
		return creditsPrice;
	}

	public void setCreditsPrice(Long creditsPrice) {
		this.creditsPrice = creditsPrice;
	}

	public Double getCreditsViewPrice() {
		return creditsViewPrice;
	}

	public void setCreditsViewPrice(Double creditsViewPrice) {
		this.creditsViewPrice = creditsViewPrice;
	}

	public Integer getFreeLimit() {
		return freeLimit;
	}

	public void setFreeLimit(Integer freeLimit) {
		this.freeLimit = freeLimit;
	}

	public String getFreeScope() {
		return freeScope;
	}

	public void setFreeScope(String freeScope) {
		this.freeScope = freeScope;
	}

	public Integer getLimitCount() {
		return limitCount;
	}

	public void setLimitCount(Integer limitCount) {
		this.limitCount = limitCount;
	}

	public String getLimitScope() {
		return limitScope;
	}

	public void setLimitScope(String limitScope) {
		this.limitScope = limitScope;
	}

	public String getBannerImage() {
		return bannerImage;
	}

	public void setBannerImage(String bannerImage) {
		this.bannerImage = bannerImage;
	}

	public String getSmallImage() {
		return smallImage;
	}

	public void setSmallImage(String smallImage) {
		this.smallImage = smallImage;
	}

	public String getWhiteImage() {
		return whiteImage;
	}

	public void setWhiteImage(String whiteImage) {
		this.whiteImage = whiteImage;
	}

	public String getLogo() {
		return logo;
	}

	public void setLogo(String logo) {
		this.logo = logo;
	}

	public Long getSwitches() {
		return switches;
	}

	public void setSwitches(Long switches) {
		this.switches = switches;
	}

	public Integer getStatus() {
		return status;
	}

	public void setStatus(Integer status) {
		this.status = status;
	}

	public Boolean getDeleted() {
		return deleted;
	}

	public void setDeleted(Boolean deleted) {
		this.deleted = deleted;
	}

	public String getRateIntroduction() {
		return rateIntroduction;
	}

	public void setRateIntroduction(String rateIntroduction) {
		this.rateIntroduction = rateIntroduction;
	}

	public Date getAutoOffDate() {
		return autoOffDate;
	}

	public void setAutoOffDate(Date autoOffDate) {
		this.autoOffDate = autoOffDate;
	}

	public Date getAutoOnDate() {
		return autoOnDate;
	}

	public void setAutoOnDate(Date autoOnDate) {
		this.autoOnDate = autoOnDate;
	}

	public String getRecommendImage() {
		return recommendImage;
	}

	public void setRecommendImage(String recommendImage) {
		this.recommendImage = recommendImage;
	}

	public String getFreeRule() {
		return freeRule;
	}

	public void setFreeRule(String freeRule) {
		this.freeRule = freeRule;
	}

	public Long getActivityCategoryId() {
		return activityCategoryId;
	}

	public void setActivityCategoryId(Long activityCategoryId) {
		this.activityCategoryId = activityCategoryId;
	}

	public String getTag() {
		return tag;
	}

	public void setTag(String tag) {
		this.tag = tag;
	}

	public String getImageJson() {
		if(StringUtils.isNotBlank(this.bannerImgNew) ||StringUtils.isNotBlank(this.smallImgNew)){
			//设置图片
			Map<String, String> keyMap = Maps.newHashMap();
			if(StringUtils.isNotBlank(this.bannerImgNew)){
				keyMap.put(BANNER_IMAGE_NEW.getCode(), this.bannerImgNew);
			}
			if(StringUtils.isNotBlank(this.smallImgNew)){
				keyMap.put(SMALL_IMAGE_NEW.getCode(), this.smallImgNew);
			}
			return JSON.toJSONString(keyMap);
		}
		return this.imageJson;
	}

	public void setImageJson(String imageJson) {
		this.imageJson = imageJson;
	}

	public Long getDuibaBrickId() {
		return duibaBrickId;
	}

	public void setDuibaBrickId(Long duibaBrickId) {
		this.duibaBrickId = duibaBrickId;
	}

	public String getExtendJson() {
		return extendJson;
	}

	public void setExtendJson(String extendJson) {
		this.extendJson = extendJson;
	}

	public String getFactoryKey() {
		return factoryKey;
	}

	public void setFactoryKey(String factoryKey) {
		this.factoryKey = factoryKey;
	}

	public Boolean getHiddenForDeveloper() {
		return hiddenForDeveloper;
	}

	public void setHiddenForDeveloper(Boolean hiddenForDeveloper) {
		this.hiddenForDeveloper = hiddenForDeveloper;
	}

	public Integer getAddTimeLimit() {
		return addTimeLimit;
	}

	public void setAddTimeLimit(Integer addTimeLimit) {
		this.addTimeLimit = addTimeLimit;
	}

	public String getBannerImgNew() {
		if (StringUtils.isNotBlank(this.imageJson)) {
			return JSON.parseObject(imageJson, new TypeReference<Map<String, String>>() {
			}).get(BANNER_IMAGE_NEW.getCode());
		}
		return StringUtils.EMPTY;
	}

	public void setBannerImgNew(String bannerImgNew) {
		this.bannerImgNew = bannerImgNew;
	}

	public String getSmallImgNew() {
		if (StringUtils.isNotBlank(this.imageJson)) {
			return JSON.parseObject(imageJson, new TypeReference<Map<String, String>>() {
			}).get(SMALL_IMAGE_NEW.getCode());
		}
		return StringUtils.EMPTY;
	}

	public void setSmallImgNew(String smallImgNew) {
		this.smallImgNew = smallImgNew;
	}

	public Integer getType() {
		return type;
	}

	public void setType(Integer type) {
		this.type = type;
	}

	public Integer getChannelType() {
		return channelType;
	}

	public void setChannelType(Integer channelType) {
		this.channelType = channelType;
	}

	public String getGameExtendJson() {
		return gameExtendJson;
	}

	public void setGameExtendJson(String gameExtendJson) {
		this.gameExtendJson = gameExtendJson;
	}
}