package cn.com.duiba.hdtool.center.api.enums;

/**
 * ClassName:RedisKeySpace<br/>
 *
 * @author gey
 * @version 1.0
 * @Description: 用于管理使用Redis的所有key前缀，避免业务key重复
 * 例如<br/>
 * K001("xxx业务缓存"),<br/>
 * K002("xxx业务分布式锁"), <br/>
 * K003("xxx业务计数器");<br/>
 * @date 创建时间：2018/3/13  17:19
 * @since JDK 1.8
 **/
public enum RedisKeySpace {

    K001("活动工具业务缓存"),
    K002("活动工具默认皮肤自定义设置"),
    K003("活动工具默认皮肤"),
    K004("活动工具默认皮肤"),
    K005("活动工具订单流水"),
    K006("活动工具答题题目信息"),
    K007("活动工具开发者定向配置"),
    K008("自定义活动工具分享配置缓存"),
    K009("活动工具列表缓存"),
    K010("游戏订单额外信息缓存"),

    ;

    /**
     * 应用名称
     */
    private static final String SPACE = "HD";

    private String desc;

    RedisKeySpace(String description) {
        this.desc = description;
    }

    public String getDesc() {
        return desc;
    }

    /**
     * 拼接key前置
     */
    @Override
    public String toString() {
        return SPACE + "_" + super.toString() + "_";
    }
}
