package cn.com.duiba.hdtool.center.api.remoteservice.order;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.hdtool.center.api.dto.order.HdtoolOrdersDto;

/**
 * ClassName:RemoteHdtoolOrdersService<br/>
 *
 * @author gey
 * @version 1.0
 * @Description: 活动工具 订单流水
 * @date 创建时间：2018/3/23  10:28
 * @since JDK 1.8
 **/
@AdvancedFeignClient
public interface RemoteHdtoolOrdersService {
	/**
	 *
	 * find:(这里用一句话描述这个方法的作用). <br/>
	 * 根据ID查询订单
	 * @param id
	 * @param consumerId
	 * @return
	 * @throws  BizException
	 * @since JDK 1.8
	 */
	public HdtoolOrdersDto find(Long id,Long consumerId) throws BizException;

	/**
	 *
	 * createOrder:(创建订单). <br/>
	 *
	 * @param hdtoolOrdersDto
	 * @return
	 * @since JDK 1.8
	 */
	public HdtoolOrdersDto createOrder(HdtoolOrdersDto hdtoolOrdersDto)throws BizException;

	/**
	 *
	 * updateLotteryResult:(这里用一句话描述这个方法的作用). <br/>
	 * 处理抽奖结果
	 * @param hdtoolOrdersDto
	 * @return
	 * @since JDK 1.8
	 */
	Integer updateLotteryResult(HdtoolOrdersDto hdtoolOrdersDto) throws BizException;

}