package cn.com.duiba.hdtool.center.api.remoteservice.record;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.hdtool.center.api.dto.record.CoinPusherAccountDto;

/**
 * @author zhangruofan
 * @date 2019/03/14
 */
@AdvancedFeignClient
public interface RemoteCoinPusherAccountService {
    /**
     * 获取用户推币机账户信息
     * @param consumerId 用户id
     * @param oaId 入库活动id
     * @return CoinPusherAccountDto
     */
    CoinPusherAccountDto findByCIdAndOaId(Long consumerId, Long oaId);

    /**
     * 用户上报当前余额
     * @param consumerId consumerId
     * @param oaId 入库活动id
     * @param balance 当前账户余额
     * @return 是否更新成功
     * @throws BizException 业务错误
     */
    Boolean submit(Long consumerId, Long oaId, Integer balance) throws BizException;

    /**
     * 获取当前用户的积分上限
     * @param consumerId 用户id
     * @param oaId 入库活动id
     * @param recoveryRate 回收率
     * @return upperLimit
     * @throws BizException 业务异常
     */
    Integer getUpperLimit(Long consumerId, Long oaId, Integer recoveryRate) throws BizException;

    /**
     * 金币兑换积分
     * @param consumerId 用户id
     * @param oaId 入库活动id
     * @param credits 兑换的积分
     * @param appKey appKey
     * @param appSecret appSecret
     * @param url 加积分链接
     * @return 是否兑换成功
     * @throws BizException 业务异常
     */
    Boolean exchange(Long consumerId, Long oaId, Integer credits, String appKey, String appSecret, String url)
            throws BizException;
}
