package cn.com.duiba.hdtool.center.api.remoteservice.order;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.hdtool.center.api.dto.order.HdtoolOrdersDto;
import cn.com.duiba.hdtool.center.api.dto.order.OrderDataResp;
import cn.com.duiba.hdtool.center.api.params.HsbcLottoDataParam;

import java.util.List;

/**
 * ClassName:RemoteHdtoolOrdersService<br/>
 *
 * @author gey
 * @version 1.0
 * @Description: 活动工具 订单流水-总表
 * @date 创建时间：2018/3/23  10:28
 * @since JDK 1.8
 **/
@AdvancedFeignClient
public interface RemoteHdtoolMngOrdersService {
	/**
	 * 
	 * findExpireOrder:(这里用一句话描述这个方法的作用). <br/>
	 * 根据领取状态exchangeStatus查询小于endTime时间的订单
	 * @return
	 * @since JDK 1.6
	 */
	public List<HdtoolOrdersDto> findExpireOrder();

	/**
	 * 查询某个appId下的活动ID下的某天数据(分页)
	 * @param hsbcLottoDataParam
	 * @return 总数和分页数据
	 */
	public OrderDataResp findByActivityIdAndOneDay(HsbcLottoDataParam hsbcLottoDataParam) throws BizException;
}
