package cn.com.duiba.hdtool.center.api.remoteservice.record;

import java.util.List;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.hdtool.center.api.dto.record.HdtoolBehaviorLogDto;

/**
 * 游戏用户行为记录服务
 * Created by hww on 2018/4/13 下午2:50.
 */
@AdvancedFeignClient
public interface RemoteHdtoolBehaviorLogService {

	/**
	 * 插入日志
	 * @param log
	 * @return
	 */
	Long insert(HdtoolBehaviorLogDto log) throws BizException;

	/**
	 * 根据游戏子订单id查询所有记录的MD5
	 * @param orderId
	 * @return
	 */
	List<String> findMd5ByOrderId(Long orderId) throws BizException;
}
