/**
 * Copyright (c) 2022, duiba.com.cn All Rights Reserved.
 */
package net.ipip.ipdb;

import java.io.Serializable;

/**
 * 描述: ip 解析 DTO
 *
 * @author guopengfei@duiba.com.cn
 * @version v1.0
 * @date 2022/2/14 10:51
 */
public class IpParseDTO implements Serializable {
    private static final long serialVersionUID = -5324826568228072232L;

    /**
     * ip地址
     */
    private String ip;

    /**
     * 国家名称
     */
    private String countryName;

    /**
     * 省份名称(区域、州)
     */
    private String regionName;

    /**
     * 城市名称
     */
    private String cityName;

    /**
     * 区域名称
     */
    private String districtName;

    /**
     * 区域编码
     */
    private String districtCode;

    /**
     * 网络域名商域名
     */
    private String ispDomain;

    /**
     * 纬度
     */
    private String latitude;

    /**
     * 精度
     */
    private String longitude;

    /**
     * 应用场景 https://www.ipip.net/product/usage.html
     */
    private String usageType;

    /**
     * owner域名
     */
    private String ownerDomain;

    /**
     * 大洲编码
     */
    private String continentCode;

    /**
     * 国家编码
     */
    private String countryCode;

    /**
     * 国家手机前缀
     */
    private String iddCode;

    /**
     * 时区
     */
    private String timezone;

    /**
     * UTC偏移量
     */
    private String utcOffset;

    public IpParseDTO() {
    }

    public IpParseDTO(CityInfo cityInfo, String ip) {
        this.ip = ip;
        this.countryName = cityInfo.getCountryName();
        this.regionName = cityInfo.getRegionName();
        this.cityName = cityInfo.getCityName();
        this.districtName = cityInfo.getDistrictName();
        this.districtCode = cityInfo.getChinaAdminCode();
        this.ispDomain = cityInfo.getIspDomain();
        this.latitude = cityInfo.getLatitude();
        this.longitude = cityInfo.getLongitude();
        this.usageType = cityInfo.getUsageType();
        this.ownerDomain = cityInfo.getOwnerDomain();
        this.continentCode = cityInfo.getContinentCode();
        this.countryCode = cityInfo.getCountryCode();
        this.iddCode = cityInfo.getIddCode();
        this.timezone = cityInfo.getTimezone();
        this.utcOffset = cityInfo.getUtcOffset();
    }

    public String getIp() {
        return ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getCountryName() {
        return countryName;
    }

    public void setCountryName(String countryName) {
        this.countryName = countryName;
    }

    public String getRegionName() {
        return regionName;
    }

    public void setRegionName(String regionName) {
        this.regionName = regionName;
    }

    public String getCityName() {
        return cityName;
    }

    public void setCityName(String cityName) {
        this.cityName = cityName;
    }

    public String getDistrictName() {
        return districtName;
    }

    public void setDistrictName(String districtName) {
        this.districtName = districtName;
    }

    public String getDistrictCode() {
        return districtCode;
    }

    public void setDistrictCode(String districtCode) {
        this.districtCode = districtCode;
    }

    public String getIspDomain() {
        return ispDomain;
    }

    public void setIspDomain(String ispDomain) {
        this.ispDomain = ispDomain;
    }

    public String getLatitude() {
        return latitude;
    }

    public void setLatitude(String latitude) {
        this.latitude = latitude;
    }

    public String getLongitude() {
        return longitude;
    }

    public void setLongitude(String longitude) {
        this.longitude = longitude;
    }

    public String getUsageType() {
        return usageType;
    }

    public void setUsageType(String usageType) {
        this.usageType = usageType;
    }

    public String getOwnerDomain() {
        return ownerDomain;
    }

    public void setOwnerDomain(String ownerDomain) {
        this.ownerDomain = ownerDomain;
    }

    public String getContinentCode() {
        return continentCode;
    }

    public void setContinentCode(String continentCode) {
        this.continentCode = continentCode;
    }

    public String getCountryCode() {
        return countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public String getIddCode() {
        return iddCode;
    }

    public void setIddCode(String iddCode) {
        this.iddCode = iddCode;
    }

    public String getTimezone() {
        return timezone;
    }

    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    public String getUtcOffset() {
        return utcOffset;
    }

    public void setUtcOffset(String utcOffset) {
        this.utcOffset = utcOffset;
    }
}
