package cn.com.duiba.cloud.jiuli.client;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.cloud.jiuli.client.domian.dto.FileDto;
import cn.com.duiba.cloud.jiuli.client.domian.params.ImageChangeParams;
import cn.com.duiba.cloud.jiuli.client.domian.params.ListFileParams;
import cn.com.duiba.cloud.jiuli.client.domian.params.RefreshCdnParams;
import cn.com.duiba.cloud.jiuli.client.domian.request.PutFileRequest;
import cn.com.duiba.cloud.jiuli.client.domian.result.CdnFlushResult;
import cn.com.duiba.cloud.jiuli.client.domian.result.GetFileResult;
import cn.com.duiba.cloud.jiuli.client.domian.result.PutFileResult;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

/**
 * 九黎文件操作客户端
 * @author liuyao
 */
public interface JiuliFileClient {

    /**
     * 空间标识
     * @return 空间标识
     */
    String getSpaceKey();

    /**
     * 列举文件
     * @param params        请求参数
     * @return 文件项
     */
    List<FileDto> listFile(ListFileParams params) throws BizException;

    /**
     * 创建文件夹
     *
     * @param filePath 文件夹路径
     */
    void createFolder(String filePath) throws BizException;

    /**
     * 上传文件
     *
     * @param filePath 文件夹路径
     */
    PutFileResult putFile(String filePath, PutFileRequest request) throws BizException;

    /**
     * 获取文件流
     *
     * @param filePath 文件路径
     * @return 文件对象
     */
    GetFileResult getFile(String filePath) throws BizException;

    /**
     * 下载到文件
     * @param filePath 文件路径
     * @param file     本地文件
     **/
    void getFile(String filePath, File file) throws IOException, BizException;

    /**
     * 文件是否存在
     *
     * @param filePath 文件路径
     * @return 是否存在
     */
    Boolean fileExist(String filePath) throws BizException;

    /**
     * 删除文件或目录。如果要删除目录，目录必须为空。
     *
     * @param filePath 文件路径
     */
    void deleteFile(String filePath) throws BizException;

    /**
     * 追加上传
     *
     * @param filePath    文件路径
     * @param position    追加点,null表示追加到末尾
     * @param inputStream 追加内容
     */
    void appendToFile(String filePath, Long position, InputStream inputStream) throws BizException;

    /**
     * 编辑图片
     * @param params 图片变更参数
     * @return 处理图片的任务号
     */
    String imageChange(ImageChangeParams params) throws BizException;

    /**
     * 刷新Cdn
     * @return 刷新结果
     */
    List<CdnFlushResult> refreshCdn(RefreshCdnParams params) throws BizException;

}
