package cn.com.duiba.cloud.jiuli.client.configuration;

import cn.com.duiba.cloud.jiuli.client.service.JiuliFileClientImpl;
import cn.com.duiba.cloud.jiuli.client.service.JiuliFileClientManager;
import cn.com.duiba.cloud.jiuli.client.service.auth.JiuliClientAuthRequestInterceptor;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.context.annotation.Scope;

/**
 * @author wangxukai
 * @date ：Created in 2021/12/20
 */
@EnableDiscoveryClient
@Configuration
@EnableAspectJAutoProxy
@EnableConfigurationProperties(FileClientProperties.class)
public class JiuliClientConfiguration {

    @Bean
    public JiuliClientAuthRequestInterceptor jiuliClientAuthRequestInterceptor(){
        return new JiuliClientAuthRequestInterceptor();
    }

    @Bean
    public JiuliFileClientManager jiuliFileClientManager(){
        return new JiuliFileClientManager();
    }

    @Bean
    @Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
    public JiuliFileClientImpl jiuliFileClient(){
        return new JiuliFileClientImpl();
    }
}
