package cn.com.duiba.cloud.jiuli.client.domian.params;

import cn.com.duiba.cloud.jiuli.client.domian.constants.HttpHeaders;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;

/**
 * @author wangxukai
 * @date ：Created in 2021/12/13
 */
@Data
public class PutFileParams implements Serializable {

    /**
     * 文件Id
     */
    @NotBlank
    private String fileId;

    private Map<String,String> metadata = Maps.newHashMap();

    private Set<String> ignoreAutoEventTypes = Sets.newHashSet();

    public String getContentType() {
        return metadata.get(HttpHeaders.CONTENT_TYPE);
    }

    /**
     * 如果未设置，九黎将根据文件类型对应contentType 做为默认 contentType
     * @param contentType The content-type header in MIME type format.
     */
    public void setContentType(String contentType) {
        metadata.put(HttpHeaders.CONTENT_TYPE, contentType);
    }

    public void ignoreAutomationEvent(String eventCode){
        ignoreAutoEventTypes.add(eventCode);
    }

}
