package cn.com.duiba.cloud.jiuli.client.domian.request;

import cn.com.duiba.cloud.jiuli.client.domian.constants.HttpHeaders;
import cn.com.duiba.cloud.jiuli.client.utils.MultipartFileUtils;
import com.google.common.collect.Maps;
import lombok.Data;
import org.springframework.web.multipart.MultipartFile;

import java.io.File;
import java.io.InputStream;
import java.util.Map;
import java.util.Objects;

/**
 * @author liuyao
 */
@Data
public class PutFileRequest {

    /**
     * 文件
     */
    private final MultipartFile file;

    private Map<String,String> metadata = Maps.newHashMap();

    /**
     * 流式上传
     * @param inputStream 数据流
     *                    注意：输入流需要自己关闭
     */
    public PutFileRequest(InputStream inputStream) {
        Objects.requireNonNull(inputStream);
        this.file = MultipartFileUtils.fileToMultipartFile(inputStream);
    }

    /**
     * 文件上传
     * @param file 本地文件
     */
    public PutFileRequest(File file) {
        Objects.requireNonNull(file);
        this.file = MultipartFileUtils.fileToMultipartFile(file);
    }

    public PutFileRequest(MultipartFile file) {
        Objects.requireNonNull(file);
        this.file = file;
    }

    public void addAllMetadata(Map<String,String> metadata){
        this.metadata.putAll(metadata);
    }

    public void addMetadata(String key,String value){
        metadata.put(key,value);
    }

    public void setContentType(String contentType) {
        metadata.put(HttpHeaders.CONTENT_TYPE, contentType);
    }

}
